/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm23.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.structure.J9VMThread;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaSystemMonitor
implements JavaMonitor {
    private final Logger log = DTFJContext.getLogger();
    private final J9ThreadMonitorPointer monitor;
    private String name = null;

    public DTFJJavaSystemMonitor(J9ThreadMonitorPointer ptr) {
        this.monitor = ptr;
        this.log.fine(String.format("Created object monitor 0x%016x", ptr.getAddress()));
    }

    public Iterator getEnterWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_BLOCKED);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public ImagePointer getID() {
        return DTFJContext.getImagePointer(this.monitor.getAddress());
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.name == null) {
            try {
                this.name = this.monitor.name().getCStringAtOffset(0L);
            }
            catch (MemoryFault e) {
                this.name = "Unknown monitor name";
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return this.name;
    }

    public Iterator getNotifyWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_WAITING);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObject() {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(this.monitor.userData());
            if (object.isNull()) {
                return null;
            }
            return new DTFJJavaObject(object);
        }
        catch (Throwable t) {
            this.log.log(Level.FINE, "Throwable when getting object", t);
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return null;
        }
    }

    public JavaThread getOwner() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9ThreadPointer owner = this.monitor.owner();
            if (owner.isNull()) {
                return null;
            }
            int vmThreadKey = DTFJContext.getVm().vmThreadKey().intValue() - 1;
            J9VMThreadPointer vmThread = J9VMThreadPointer.cast(owner.tlsEA().at(vmThreadKey));
            return new DTFJJavaThread(vmThread);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private Iterator<DTFJJavaThread> scanThreads(long threadState) throws CorruptDataException {
        List<J9VMThreadPointerUtil.ThreadInfo> threadInfoCache = DTFJContext.getThreadInfoCache();
        ArrayList<DTFJJavaThread> threads = new ArrayList<DTFJJavaThread>();
        for (int i = 0; i < threadInfoCache.size(); ++i) {
            J9VMThreadPointerUtil.ThreadInfo info = threadInfoCache.get(i);
            if ((info.getState() & threadState) == 0L || !info.getRawLock().eq(this.monitor)) continue;
            DTFJJavaThread dtfjThread = new DTFJJavaThread(info.getThread());
            threads.add(dtfjThread);
        }
        return threads.iterator();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTFJJavaSystemMonitor)) {
            return false;
        }
        DTFJJavaSystemMonitor test = (DTFJJavaSystemMonitor)obj;
        return this.monitor.eq(test.monitor);
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }
}

