/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm23.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.structure.J9VMThread;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DTFJJavaObjectMonitor
implements JavaMonitor {
    private final Logger log = DTFJContext.getLogger();
    private final J9ObjectPointer object;
    private String name = null;

    public DTFJJavaObjectMonitor(J9ObjectPointer ptr) {
        this.object = ptr;
        this.log.fine(String.format("Created object monitor 0x%016x", ptr.getAddress()));
    }

    public Iterator getEnterWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_BLOCKED);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public ImagePointer getID() {
        return DTFJContext.getImagePointer(this.object.getAddress());
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.name == null) {
            String address = Long.toHexString(this.object.getAddress());
            this.name = String.format("(un-named monitor @0x%s for object @0x%s)", address, address);
        }
        return this.name;
    }

    public Iterator getNotifyWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_WAITING);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObject() {
        return new DTFJJavaObject(this.object);
    }

    public JavaThread getOwner() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            long address = this.object.monitor().longValue() & 0xFFFFFFFFFFFFFF00L;
            J9VMThreadPointer vmThread = J9VMThreadPointer.cast(address);
            return new DTFJJavaThread(vmThread);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private Iterator<DTFJJavaThread> scanThreads(long threadState) throws CorruptDataException {
        List<J9VMThreadPointerUtil.ThreadInfo> threadInfoCache = DTFJContext.getThreadInfoCache();
        ArrayList<DTFJJavaThread> threads = new ArrayList<DTFJJavaThread>();
        for (int i = 0; i < threadInfoCache.size(); ++i) {
            J9VMThreadPointerUtil.ThreadInfo info = threadInfoCache.get(i);
            if ((info.getState() & threadState) == 0L || info.getLockObject() == null || !info.getLockObject().eq(this.object)) continue;
            DTFJJavaThread dtfjThread = new DTFJJavaThread(info.getThread());
            threads.add(dtfjThread);
        }
        return threads.iterator();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTFJJavaObjectMonitor)) {
            return false;
        }
        DTFJJavaObjectMonitor test = (DTFJJavaObjectMonitor)obj;
        return this.getID().equals((Object)test.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

