/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import com.ibm.j9ddr.vm23.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm23.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.IAlgorithm;
import com.ibm.j9ddr.vm23.pointer.generated.J9RASPointer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class J9RASInfoBootstrapShim
implements IBootstrapRunnable {
    private static J9RASInfoObject_23_V0 impl;
    private static final AlgorithmPicker<J9RASInfoObject_23_V0> picker;

    private static J9RASInfoObject_23_V0 getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    @Override
    public void run(IVMData vmData, Object[] userData) {
        Object[] passbackArray = (Object[])userData[0];
        passbackArray[0] = J9RASInfoBootstrapShim.getImpl();
    }

    static {
        picker = new AlgorithmPicker<J9RASInfoObject_23_V0>("ALG_J9RAS_VERSION"){

            @Override
            protected Iterable<? extends J9RASInfoObject_23_V0> allAlgorithms() {
                LinkedList<J9RASInfoObject_23_V0> toReturn = new LinkedList<J9RASInfoObject_23_V0>();
                toReturn.add(new J9RASInfoObject_23_V0());
                toReturn.add(new J9RASInfoObject_23_V1());
                return toReturn;
            }
        };
    }

    private static class J9RASInfoObject_23_V1
    extends J9RASInfoObject_23_V0
    implements IAlgorithm,
    J9RASImageDataFactory.MachineData,
    J9RASImageDataFactory.ProcessData {
        protected J9RASInfoObject_23_V1() {
            super(1);
        }

        @Override
        public long pid() throws CorruptDataException, DataUnavailable {
            throw new DataUnavailable("J9RAS.pid not available in SR9 and earlier");
        }

        @Override
        public long tid() throws CorruptDataException, DataUnavailable {
            throw new DataUnavailable("J9RAS.tid not available in SR9 and earlier");
        }
    }

    private static class J9RASInfoObject_23_V0
    extends BaseAlgorithm
    implements IAlgorithm,
    J9RASImageDataFactory.MachineData,
    J9RASImageDataFactory.ProcessData {
        private final J9RASPointer ptr = DataType.getJ9RASPointer();

        protected J9RASInfoObject_23_V0() {
            super(30, 0);
        }

        protected J9RASInfoObject_23_V0(int algorithmVersion) {
            super(30, algorithmVersion);
        }

        @Override
        public int version() throws CorruptDataException {
            return this.ptr.version().intValue() >> 16;
        }

        @Override
        public int cpus() throws CorruptDataException {
            try {
                return this.ptr.cpus().intValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.cpus().getHexValue(), e);
            }
        }

        @Override
        public long memoryBytes() throws CorruptDataException {
            try {
                return this.ptr.memory().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.memory().getHexValue(), e);
            }
        }

        @Override
        public String osArch() throws CorruptDataException {
            return this.ptr.osarchEA().getCStringAtOffset(0L);
        }

        @Override
        public String osName() throws CorruptDataException {
            return this.ptr.osnameEA().getCStringAtOffset(0L);
        }

        @Override
        public String osVersion() throws CorruptDataException {
            return this.ptr.osversionEA().getCStringAtOffset(0L);
        }

        @Override
        public long pid() throws CorruptDataException, DataUnavailable {
            try {
                return this.ptr.pid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.pid().getHexValue(), e);
            }
        }

        @Override
        public long tid() throws CorruptDataException, DataUnavailable {
            try {
                return this.ptr.tid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.tid().getHexValue(), e);
            }
        }

        @Override
        public String gpInfo() throws CorruptDataException {
            if (this.ptr.crashInfo().notNull()) {
                if (this.ptr.crashInfo().gpInfo().notNull()) {
                    return this.ptr.crashInfo().gpInfo().getCStringAtOffset(0L);
                }
                return null;
            }
            return "";
        }

        @Override
        public String hostName() throws DataUnavailableException {
            throw new DataUnavailableException("Host name support is not available in this version");
        }

        @Override
        public Iterator<Object> ipaddresses() throws DataUnavailableException {
            throw new DataUnavailableException("IP address support is not available in this version");
        }

        @Override
        public IProcess getProcess() {
            return DataType.getProcess();
        }

        @Override
        public long getEnvironment() throws CorruptDataException {
            return this.ptr.environment().longValue();
        }

        @Override
        public Properties systemInfo() throws DataUnavailableException, CorruptDataException {
            return new Properties();
        }

        @Override
        public long dumpTimeMillis() throws DataUnavailableException, CorruptDataException {
            throw new DataUnavailableException("Dump creation time (millisecs) not available in 2.3 JVMs");
        }

        @Override
        public long dumpTimeNanos() throws DataUnavailableException, CorruptDataException {
            throw new DataUnavailableException("Dump creation time (nanosecs) not available in 2.3 JVMs");
        }
    }
}

