/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm23.types.I16;
import com.ibm.j9ddr.vm23.types.I32;
import com.ibm.j9ddr.vm23.types.I8;
import com.ibm.j9ddr.vm23.types.IDATA;
import com.ibm.j9ddr.vm23.types.IScalar;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.U64;
import com.ibm.j9ddr.vm23.types.U8;

public class I64
extends IScalar {
    public static final int SIZEOF = 8;
    public static final long MASK = -1L;
    public static final I64 MIN = new I64(Long.MIN_VALUE);
    public static final I64 MAX = new I64(Long.MAX_VALUE);

    public I64(long value) {
        super(value);
    }

    public I64(Scalar parameter) {
        super(parameter);
    }

    public I64 add(int number) {
        return new I64(this.data + (long)number);
    }

    public I64 add(U8 parameter) {
        return this.add(new I64(parameter));
    }

    public I64 add(U16 parameter) {
        return this.add(new I64(parameter));
    }

    public I64 add(U32 parameter) {
        return this.add(new I64(parameter));
    }

    public U64 add(U64 parameter) {
        return new U64(this).add(new I64(parameter));
    }

    public boolean eq(U64 parameter) {
        return new U64(this).eq(new I64(parameter));
    }

    public I64 add(I8 parameter) {
        return this.add(new I64(parameter));
    }

    public I64 add(I16 parameter) {
        return this.add(new I64(parameter));
    }

    public I64 add(I32 parameter) {
        return this.add(new I64(parameter));
    }

    public I64 add(I64 parameter) {
        return new I64(this.data + parameter.data);
    }

    public I64 add(IDATA parameter) {
        return this.add(new I64(parameter));
    }

    public I64 sub(int number) {
        return new I64(this.data - (long)number);
    }

    public I64 sub(U8 parameter) {
        return this.sub(new I64(parameter));
    }

    public I64 sub(U16 parameter) {
        return this.sub(new I64(parameter));
    }

    public I64 sub(U32 parameter) {
        return this.sub(new I64(parameter));
    }

    public U64 sub(U64 parameter) {
        return new U64(this).sub(new I64(parameter));
    }

    public I64 sub(I8 parameter) {
        return this.sub(new I64(parameter));
    }

    public I64 sub(I16 parameter) {
        return this.sub(new I64(parameter));
    }

    public I64 sub(I32 parameter) {
        return this.sub(new I64(parameter));
    }

    public I64 sub(I64 parameter) {
        return new I64(this.data - parameter.data);
    }

    public I64 sub(IDATA parameter) {
        return this.sub(new I64(parameter));
    }

    @Override
    public int intValue() {
        if (super.intValue() < 0) {
            throw new InvalidDataTypeException("I_64 contains number larger than MAX_INT");
        }
        return super.intValue();
    }

    public I64 bitOr(int number) {
        return new I64(this.data | (long)number);
    }

    public I64 bitOr(long number) {
        return new I64(this.data | number);
    }

    public I64 bitOr(U8 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitOr(U16 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitOr(U32 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public U64 bitOr(U64 parameter) {
        return new U64(this).bitOr(new I64(parameter));
    }

    public I64 bitOr(I8 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitOr(I16 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitOr(I32 parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitOr(I64 parameter) {
        return new I64(this.data | parameter.data);
    }

    public I64 bitOr(IDATA parameter) {
        return this.bitOr(new I64(parameter));
    }

    public I64 bitAnd(int number) {
        return new I64(this.data & (long)number);
    }

    public I64 bitAnd(long number) {
        return new I64(this.data & number);
    }

    public I64 bitAnd(U8 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 bitAnd(U16 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 bitAnd(U32 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public U64 bitAnd(U64 parameter) {
        return new U64(this).bitAnd(new I64(parameter));
    }

    public I64 bitAnd(I8 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 bitAnd(I16 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 bitAnd(I32 parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 bitAnd(I64 parameter) {
        return new I64(this.data & parameter.data);
    }

    public I64 bitAnd(IDATA parameter) {
        return this.bitAnd(new I64(parameter));
    }

    public I64 leftShift(int i) {
        return new I64(this.data << i);
    }

    public I64 rightShift(int i) {
        return new I64(this.data >> i);
    }

    public I64 bitNot() {
        return new I64(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public I64 mult(int parameter) {
        return new I64(this.data * (long)parameter);
    }

    public boolean lt(I64 parameter) {
        return this.data < parameter.data;
    }

    public boolean gt(I64 parameter) {
        return this.data > parameter.data;
    }

    @Override
    public int sizeof() {
        return 8;
    }
}

