/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ScalarFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final Method castMethod;
    private final Method atMethod;
    private final Class<? extends AbstractPointer> pointerClass;

    public ScalarFormatter(int typeCode, Class<? extends AbstractPointer> pointerClass) {
        this.typeCode = typeCode;
        try {
            this.castMethod = pointerClass.getMethod("cast", Long.TYPE);
            this.atMethod = pointerClass.getMethod("at", Long.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pointerClass = pointerClass;
    }

    protected void formatShortScalar(Scalar value, PrintStream out) {
        out.print("0x" + Long.toHexString(value.longValue()));
        out.print(" (");
        out.print(value.longValue());
        out.print(")");
    }

    @Override
    public FormatWalkResult format(String name, String type2, String declaredType, int thisTypeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        if (thisTypeCode == this.typeCode) {
            Object o = null;
            try {
                o = this.castMethod.invoke(null, address);
            }
            catch (Exception e) {
                throw new RuntimeException("Cast failed on " + this.pointerClass.getName(), e);
            }
            try {
                Scalar value = (Scalar)this.atMethod.invoke(o, 0L);
                this.formatShortScalar(value, out);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CorruptDataException) {
                    throw (CorruptDataException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Problem invoking at() method on " + this.pointerClass.getName(), e);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem invoking at() method on " + this.pointerClass.getName(), e);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }
}

