/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm23.pointer.I32Pointer;
import com.ibm.j9ddr.vm23.pointer.IDATAPointer;
import java.io.PrintStream;

public class J9SRPFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final String srpPrefix;
    private final boolean wide;

    public J9SRPFormatter(int typeCode, String srpPrefix, boolean wide) {
        this.typeCode = typeCode;
        this.srpPrefix = srpPrefix;
        this.wide = wide;
    }

    private String stripSRP(String type2) {
        type2 = type2.trim();
        return type2.substring(this.srpPrefix.length(), type2.length() - 1);
    }

    @Override
    public FormatWalkResult format(String name, String type2, String declaredType, int thisTypeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        long offset;
        if (thisTypeCode != this.typeCode) {
            return FormatWalkResult.KEEP_WALKING;
        }
        if (this.wide) {
            IDATAPointer ptr = IDATAPointer.cast(address);
            offset = ptr.at(0L).longValue();
        } else {
            I32Pointer ptr = I32Pointer.cast(address);
            offset = ptr.at(0L).longValue();
        }
        if (type2.contains("(")) {
            type2 = this.stripSRP(type2);
            structureFormatter.formatField(name, type2, type2, address + offset, out, context);
        } else {
            out.print("!j9x ");
            out.print(StructureCommandUtil.formatPointer(address + offset, context));
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

