/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ThreadsCommand
extends Command {
    public ThreadsCommand() {
        this.addCommand("threads", "[help]", "Lists VM threads");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x", threadCursor.getAddress(), threadCursor.getAddress(), threadCursor.osThread().getAddress(), threadCursor.osThread().tid().longValue()));
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

