/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.pointer.I32Pointer;
import com.ibm.j9ddr.vm23.pointer.I64Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm23.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm23.structure.J9Object;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectHelper {
    public static J9ClassPointer clazz(J9ObjectPointer objPointer) throws CorruptDataException {
        return objPointer.clazz();
    }

    public static boolean getBooleanField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return J9ObjectHelper.getIntField(objPointer, offset) != 0;
    }

    public static byte getByteField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (byte)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFF);
    }

    public static char getCharField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (char)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static String getClassName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9ObjectHelper.clazz(objPointer));
    }

    public static double getDoubleField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        long data = J9ObjectHelper.getLongField(objPointer, offset);
        return Double.longBitsToDouble(data);
    }

    public static J9ObjectFieldOffset getFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ClassPointer clazz = J9ObjectHelper.clazz(objPointer);
        J9ObjectFieldOffset result = J9ClassHelper.checkFieldOffsetCache(clazz, name, signature);
        if (result == null) {
            result = J9ObjectHelper.readFieldOffset(objPointer, name, signature);
            J9ClassHelper.setFieldOffsetCache(clazz, result, name, signature);
        }
        return result;
    }

    public static float getFloatField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        int data = J9ObjectHelper.getIntField(objPointer, offset);
        return Float.intBitsToFloat(data);
    }

    public static int getIntField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I32Pointer pointer = offset.isStatic() ? I32Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).intValue();
    }

    public static long getLongField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I64Pointer pointer = offset.isStatic() ? I64Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I64Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).longValue();
    }

    public static J9ObjectPointer getObjectField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        if (offset.isStatic()) {
            UDATAPointer pointer = J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress());
            return J9ObjectPointer.cast(pointer.at(0L));
        }
        return J9ObjectHelper.getPointerAtOffset(objPointer, J9Object.SIZEOF + offset.getOffsetOrAddress().longValue());
    }

    private static J9ObjectPointer getPointerAtOffset(J9ObjectPointer objPointer, long offset) throws CorruptDataException {
        long address = objPointer.getAddress();
        if (address == 0L) {
            throw new NullPointerDereference();
        }
        return J9ObjectPointer.cast(DataType.getProcess().getPointerAt(address + offset));
    }

    public static short getShortField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (short)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static String getStringField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        J9ObjectPointer stringObject = J9ObjectHelper.getObjectField(objPointer, offset);
        if (stringObject.isNull()) {
            return null;
        }
        return J9ObjectHelper.stringValue(stringObject);
    }

    private static J9ObjectFieldOffset readFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ClassPointer currentClass = J9ObjectHelper.clazz(objPointer);
        while (currentClass.notNull()) {
            Iterator<?> fields = J9ClassHelper.getFieldOffsets(currentClass);
            while (fields.hasNext()) {
                J9ObjectFieldOffset field = (J9ObjectFieldOffset)fields.next();
                if (!field.getName().equals(name) || !field.getSignature().equals(signature)) continue;
                return field;
            }
            currentClass = J9ClassHelper.superclass(currentClass);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", name, signature, J9ObjectHelper.getClassName(objPointer)));
    }

    public static String stringValue(J9ObjectPointer objPointer) throws CorruptDataException {
        if (!J9ObjectHelper.getClassName(objPointer).equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        J9ObjectPointer charsObject = J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[C"));
        J9IndexableObjectPointer charsArray = J9IndexableObjectPointer.cast(charsObject);
        char[] value = (char[])J9IndexableObjectHelper.getData(charsArray);
        int offset = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "offset", "I"));
        int count = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "count", "I"));
        return new String(value, offset, count);
    }
}

