/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.pointer.I16Pointer;
import com.ibm.j9ddr.vm23.pointer.I32Pointer;
import com.ibm.j9ddr.vm23.pointer.I64Pointer;
import com.ibm.j9ddr.vm23.pointer.I8Pointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm23.structure.J9IndexableObject;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

public class J9IndexableObjectHelper {
    private static J9ClassPointer clazz(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        long address = objPointer.getAddress();
        if (address == 0L) {
            throw new NullPointerDereference();
        }
        long pointer = DataType.getProcess().getPointerAt(address + (long)J9IndexableObject._clazzOffset_);
        return J9ClassPointer.cast(pointer);
    }

    private static boolean[] getBooleanData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        boolean[] dst = new boolean[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = 0 != I8Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 1L)).at(0L).intValue();
        }
        return dst;
    }

    private static byte[] getByteData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        byte[] dst = new byte[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = (byte)I8Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 1L)).at(0L).intValue();
        }
        return dst;
    }

    private static char[] getCharData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        char[] dst = new char[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = (char)I16Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 2L)).at(0L).intValue();
        }
        return dst;
    }

    private static String getClassName(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9IndexableObjectHelper.clazz(objPointer));
    }

    public static Object getData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(objPointer);
        switch (className.charAt(1)) {
            case 'B': {
                return J9IndexableObjectHelper.getByteData(objPointer);
            }
            case 'C': {
                return J9IndexableObjectHelper.getCharData(objPointer);
            }
            case 'D': {
                return J9IndexableObjectHelper.getDoubleData(objPointer);
            }
            case 'F': {
                return J9IndexableObjectHelper.getFloatData(objPointer);
            }
            case 'I': {
                return J9IndexableObjectHelper.getIntData(objPointer);
            }
            case 'J': {
                return J9IndexableObjectHelper.getLongData(objPointer);
            }
            case 'S': {
                return J9IndexableObjectHelper.getShortData(objPointer);
            }
            case 'Z': {
                return J9IndexableObjectHelper.getBooleanData(objPointer);
            }
            case 'L': 
            case '[': {
                return J9IndexableObjectHelper.getObjectData(objPointer);
            }
        }
        throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
    }

    public static void getData(J9IndexableObjectPointer objPointer, Object dst, int start, int length, int destStart) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(objPointer);
        int arraySize = J9IndexableObjectHelper.size(objPointer).intValue();
        if (start + length > arraySize) {
            throw new ArrayIndexOutOfBoundsException("Requested range " + start + " to " + (start + length) + " overflows source array of length " + arraySize);
        }
        switch (className.charAt(1)) {
            case 'B': {
                if (!(dst instanceof byte[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with byte array (expects byte[])");
                }
                byte[] store = (byte[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                byte[] data = J9IndexableObjectHelper.getByteData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'C': {
                if (!(dst instanceof char[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with char array (expects char[])");
                }
                char[] store = (char[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                char[] data = J9IndexableObjectHelper.getCharData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'D': {
                if (!(dst instanceof double[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with double array (expects double[])");
                }
                double[] store = (double[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                double[] data = J9IndexableObjectHelper.getDoubleData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'F': {
                if (!(dst instanceof float[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with float array (expects float[])");
                }
                float[] store = (float[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                float[] data = J9IndexableObjectHelper.getFloatData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'I': {
                if (!(dst instanceof int[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with int array (expects int[])");
                }
                int[] store = (int[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                int[] data = J9IndexableObjectHelper.getIntData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'J': {
                if (!(dst instanceof long[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with long array (expects long[])");
                }
                long[] store = (long[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                long[] data = J9IndexableObjectHelper.getLongData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'S': {
                if (!(dst instanceof short[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with short array (expects short[])");
                }
                short[] store = (short[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                short[] data = J9IndexableObjectHelper.getShortData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'Z': {
                if (!(dst instanceof boolean[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with boolean array (expects boolean[])");
                }
                boolean[] store = (boolean[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                boolean[] data = J9IndexableObjectHelper.getBooleanData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            case 'L': 
            case '[': {
                if (!(dst instanceof J9ObjectPointer[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with Object array (expects J9ObjectPointer[])");
                }
                J9ObjectPointer[] store = (J9ObjectPointer[])dst;
                if (destStart + length > store.length) {
                    throw new ArrayIndexOutOfBoundsException("Requested range " + destStart + " to " + (destStart + length) + " overflows destination array of length " + store.length);
                }
                J9ObjectPointer[] data = J9IndexableObjectHelper.getObjectData(objPointer);
                for (int i = 0; i < length; ++i) {
                    store[destStart + i] = data[start + i];
                }
                break;
            }
            default: {
                throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
            }
        }
    }

    private static double[] getDoubleData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        double[] dst = new double[size];
        for (int i = 0; i < size; ++i) {
            long bits = I64Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 8L)).at(0L).longValue();
            dst[i] = Double.longBitsToDouble(bits);
        }
        return dst;
    }

    private static long getElementAddress(J9IndexableObjectPointer objPointer, int elementIndex, long elementSize) throws CorruptDataException {
        long address = objPointer.getAddress();
        if (address == 0L) {
            throw new NullPointerDereference();
        }
        long offset = J9IndexableObject.SIZEOF + (long)elementIndex * elementSize;
        return DataType.getProcess().getPointerAt(address + offset);
    }

    private static float[] getFloatData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        float[] dst = new float[size];
        for (int i = 0; i < size; ++i) {
            int bits = I32Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 4L)).at(0L).intValue();
            dst[i] = Float.intBitsToFloat(bits);
        }
        return dst;
    }

    private static int[] getIntData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        int[] dst = new int[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = I32Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 4L)).at(0L).intValue();
        }
        return dst;
    }

    private static long[] getLongData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        long[] dst = new long[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = I64Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 8L)).at(0L).longValue();
        }
        return dst;
    }

    private static J9ObjectPointer[] getObjectData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        J9ObjectPointer[] dst = new J9ObjectPointer[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = J9ObjectPointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, UDATA.SIZEOF));
        }
        return dst;
    }

    private static short[] getShortData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        int size = J9IndexableObjectHelper.size(objPointer).intValue();
        short[] dst = new short[size];
        for (int i = 0; i < size; ++i) {
            dst[i] = (short)I16Pointer.cast(J9IndexableObjectHelper.getElementAddress(objPointer, i, 2L)).at(0L).intValue();
        }
        return dst;
    }

    private static U32 size(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        U32 size = objPointer.size();
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return size;
    }
}

