/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.types.U32;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class J9ClassHelper {
    private static final Map<Long, Map<String, J9ObjectFieldOffset>> classToFieldOffsetCacheMap = new HashMap<Long, Map<String, J9ObjectFieldOffset>>();
    private static final Map<String, Character> TYPE_MAP = new HashMap<String, Character>();
    private static final int MAXIMUM_ARRAY_ARITY = 100;
    private static final Function<Long, Map<String, J9ObjectFieldOffset>> mapProvider;

    public static String getArrayName(J9ClassPointer clazz) throws CorruptDataException {
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        StringBuilder name = new StringBuilder();
        int arity = 0;
        try {
            arity = arrayClass.arity().intValue();
        }
        catch (InvalidDataTypeException e) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Array arity larger than MAXINT");
        }
        if (arity > 100) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Very high arity " + arity + " from array class 0x" + Long.toHexString(arrayClass.getAddress()));
        }
        for (int i = 0; i < arity; ++i) {
            name.append('[');
        }
        String elementClassName = J9ClassHelper.getName(arrayClass.leafComponentType());
        Character type2 = TYPE_MAP.get(elementClassName);
        if (type2 != null) {
            name.append(type2);
        } else {
            name.append('L');
            name.append(elementClassName);
            name.append(";");
        }
        return name.toString();
    }

    public static boolean isArrayClass(J9ClassPointer clazz) throws CorruptDataException {
        long modifiers = clazz.romClass().modifiers().longValue();
        return (modifiers & J9Consts.J9_JAVA_CLASS_ARRAY) != 0L;
    }

    public static long depth(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.classDepthAndFlags().longValue() & J9Consts.J9_JAVA_CLASS_DEPTH_MASK;
    }

    public static String getJavaName(J9ClassPointer clazz) throws CorruptDataException {
        String baseName = J9ClassHelper.getName(clazz);
        char ch = baseName.charAt(0);
        if (ch == '[') {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
            int arity = arrayClass.arity().intValue();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < arity; ++i) {
                buf.append("[]");
            }
            String aritySuffix = buf.toString();
            ch = baseName.charAt(1);
            switch (ch) {
                case 'B': {
                    return "byte" + aritySuffix;
                }
                case 'C': {
                    return "char" + aritySuffix;
                }
                case 'D': {
                    return "double" + aritySuffix;
                }
                case 'F': {
                    return "float" + aritySuffix;
                }
                case 'I': {
                    return "int" + aritySuffix;
                }
                case 'J': {
                    return "long" + aritySuffix;
                }
                case 'S': {
                    return "void" + aritySuffix;
                }
                case 'V': {
                    return "void" + aritySuffix;
                }
                case 'Z': {
                    return "boolean" + aritySuffix;
                }
                case 'L': {
                    return J9ClassHelper.getName(arrayClass.leafComponentType()) + aritySuffix;
                }
            }
        }
        return baseName;
    }

    public static J9ConstantPoolPointer ramConstantPool(J9ClassPointer clazz) throws CorruptDataException {
        return J9ConstantPoolPointer.cast(clazz.ramMethods().add(clazz.romClass().romMethodCount()));
    }

    public static String getName(J9ClassPointer clazz) throws CorruptDataException {
        return J9UTF8Helper.stringValue(clazz.romClass().className());
    }

    public static Iterator<?> getFieldOffsets(J9ClassPointer clazz) throws CorruptDataException {
        return J9ClassHelper.getFieldOffsets(clazz, J9ClassHelper.superclass(clazz));
    }

    public static J9ClassPointer superclass(J9ClassPointer clazz) throws CorruptDataException {
        long index = J9ClassHelper.depth(clazz) - 1L;
        if (index < 0L) {
            return J9ClassPointer.NULL;
        }
        VoidPointer j9ClassInstancePointer = clazz.superclasses().at(index);
        return J9ClassPointer.cast(j9ClassInstancePointer);
    }

    public static Iterator<?> getFieldOffsets(J9ClassPointer clazz, J9ClassPointer superClass) {
        U32 flags = new U32(3L);
        return J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(clazz, superClass, flags);
    }

    public static J9ObjectFieldOffset checkFieldOffsetCache(J9ClassPointer clazz, String fieldName, String signature) {
        Map<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        return fieldOffsetCache.get(fieldName + "." + signature);
    }

    public static void setFieldOffsetCache(J9ClassPointer clazz, J9ObjectFieldOffset offset, String fieldName, String signature) {
        Map<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        fieldOffsetCache.put(fieldName + "." + signature, offset);
    }

    private static Map<String, J9ObjectFieldOffset> getFieldOffsetCache(J9ClassPointer clazz) {
        return classToFieldOffsetCacheMap.computeIfAbsent(clazz.getAddress(), mapProvider);
    }

    static {
        TYPE_MAP.put("boolean", Character.valueOf('Z'));
        TYPE_MAP.put("byte", Character.valueOf('B'));
        TYPE_MAP.put("char", Character.valueOf('C'));
        TYPE_MAP.put("short", Character.valueOf('S'));
        TYPE_MAP.put("int", Character.valueOf('I'));
        TYPE_MAP.put("long", Character.valueOf('J'));
        TYPE_MAP.put("float", Character.valueOf('F'));
        TYPE_MAP.put("double", Character.valueOf('D'));
        mapProvider = new Function<Long, Map<String, J9ObjectFieldOffset>>(){

            @Override
            public Map<String, J9ObjectFieldOffset> apply(Long key) {
                return new HashMap<String, J9ObjectFieldOffset>();
            }
        };
    }
}

