/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.structure.J9ThreadGlobal;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9ThreadGlobal.class)
public class J9ThreadGlobalPointer
extends StructurePointer {
    public static final J9ThreadGlobalPointer NULL = new J9ThreadGlobalPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9ThreadGlobalPointer(long address) {
        super(address);
    }

    public static J9ThreadGlobalPointer cast(AbstractPointer structure) {
        return J9ThreadGlobalPointer.cast(structure.getAddress());
    }

    public static J9ThreadGlobalPointer cast(UDATA udata) {
        return J9ThreadGlobalPointer.cast(udata.longValue());
    }

    public static J9ThreadGlobalPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ThreadGlobalPointer(address);
    }

    @Override
    public J9ThreadGlobalPointer add(long count) {
        return J9ThreadGlobalPointer.cast(this.address + J9ThreadGlobal.SIZEOF * count);
    }

    @Override
    public J9ThreadGlobalPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9ThreadGlobalPointer addOffset(long offset) {
        return J9ThreadGlobalPointer.cast(this.address + offset);
    }

    @Override
    public J9ThreadGlobalPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ThreadGlobalPointer sub(long count) {
        return J9ThreadGlobalPointer.cast(this.address - J9ThreadGlobal.SIZEOF * count);
    }

    @Override
    public J9ThreadGlobalPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9ThreadGlobalPointer subOffset(long offset) {
        return J9ThreadGlobalPointer.cast(this.address - offset);
    }

    @Override
    public J9ThreadGlobalPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9ThreadGlobalPointer untag(long mask) {
        return J9ThreadGlobalPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9ThreadGlobalPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9ThreadGlobal.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataOffset_", declaredType="UDATA")
    public UDATA data() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9ThreadGlobal._dataOffset_));
    }

    public UDATAPointer dataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9ThreadGlobal._dataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="char*")
    public U8Pointer name() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(J9ThreadGlobal._nameOffset_));
    }

    public PointerPointer nameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ThreadGlobal._nameOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="struct J9ThreadGlobal*")
    public J9ThreadGlobalPointer next() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9ThreadGlobal._nextOffset_);
        return J9ThreadGlobalPointer.cast(pointer);
    }

    public PointerPointer nextEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ThreadGlobal._nextOffset_);
    }
}

