/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.structure.J9NativeLibrary;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9NativeLibrary.class)
public class J9NativeLibraryPointer
extends StructurePointer {
    public static final J9NativeLibraryPointer NULL = new J9NativeLibraryPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9NativeLibraryPointer(long address) {
        super(address);
    }

    public static J9NativeLibraryPointer cast(AbstractPointer structure) {
        return J9NativeLibraryPointer.cast(structure.getAddress());
    }

    public static J9NativeLibraryPointer cast(UDATA udata) {
        return J9NativeLibraryPointer.cast(udata.longValue());
    }

    public static J9NativeLibraryPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9NativeLibraryPointer(address);
    }

    @Override
    public J9NativeLibraryPointer add(long count) {
        return J9NativeLibraryPointer.cast(this.address + J9NativeLibrary.SIZEOF * count);
    }

    @Override
    public J9NativeLibraryPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9NativeLibraryPointer addOffset(long offset) {
        return J9NativeLibraryPointer.cast(this.address + offset);
    }

    @Override
    public J9NativeLibraryPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9NativeLibraryPointer sub(long count) {
        return J9NativeLibraryPointer.cast(this.address - J9NativeLibrary.SIZEOF * count);
    }

    @Override
    public J9NativeLibraryPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9NativeLibraryPointer subOffset(long offset) {
        return J9NativeLibraryPointer.cast(this.address - offset);
    }

    @Override
    public J9NativeLibraryPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9NativeLibraryPointer untag(long mask) {
        return J9NativeLibraryPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9NativeLibraryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9NativeLibrary.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_handleOffset_", declaredType="UDATA")
    public UDATA handle() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9NativeLibrary._handleOffset_));
    }

    public UDATAPointer handleEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9NativeLibrary._handleOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="char*")
    public U8Pointer name() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(J9NativeLibrary._nameOffset_));
    }

    public PointerPointer nameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9NativeLibrary._nameOffset_);
    }
}

