/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.structure.J9LineNumber;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9LineNumber.class)
public class J9LineNumberPointer
extends StructurePointer {
    public static final J9LineNumberPointer NULL = new J9LineNumberPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9LineNumberPointer(long address) {
        super(address);
    }

    public static J9LineNumberPointer cast(AbstractPointer structure) {
        return J9LineNumberPointer.cast(structure.getAddress());
    }

    public static J9LineNumberPointer cast(UDATA udata) {
        return J9LineNumberPointer.cast(udata.longValue());
    }

    public static J9LineNumberPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9LineNumberPointer(address);
    }

    @Override
    public J9LineNumberPointer add(long count) {
        return J9LineNumberPointer.cast(this.address + J9LineNumber.SIZEOF * count);
    }

    @Override
    public J9LineNumberPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9LineNumberPointer addOffset(long offset) {
        return J9LineNumberPointer.cast(this.address + offset);
    }

    @Override
    public J9LineNumberPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9LineNumberPointer sub(long count) {
        return J9LineNumberPointer.cast(this.address - J9LineNumber.SIZEOF * count);
    }

    @Override
    public J9LineNumberPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9LineNumberPointer subOffset(long offset) {
        return J9LineNumberPointer.cast(this.address - offset);
    }

    @Override
    public J9LineNumberPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9LineNumberPointer untag(long mask) {
        return J9LineNumberPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9LineNumberPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9LineNumber.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_lineNumberOffset_", declaredType="U32")
    public U32 lineNumber() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9LineNumber._lineNumberOffset_));
    }

    public U32Pointer lineNumberEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9LineNumber._lineNumberOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_locationOffset_", declaredType="U32")
    public U32 location() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9LineNumber._locationOffset_));
    }

    public U32Pointer locationEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9LineNumber._locationOffset_);
    }
}

