/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm23.structure.J9HashTable;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9HashTable.class)
public class J9HashTablePointer
extends StructurePointer {
    public static final J9HashTablePointer NULL = new J9HashTablePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9HashTablePointer(long address) {
        super(address);
    }

    public static J9HashTablePointer cast(AbstractPointer structure) {
        return J9HashTablePointer.cast(structure.getAddress());
    }

    public static J9HashTablePointer cast(UDATA udata) {
        return J9HashTablePointer.cast(udata.longValue());
    }

    public static J9HashTablePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9HashTablePointer(address);
    }

    @Override
    public J9HashTablePointer add(long count) {
        return J9HashTablePointer.cast(this.address + J9HashTable.SIZEOF * count);
    }

    @Override
    public J9HashTablePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9HashTablePointer addOffset(long offset) {
        return J9HashTablePointer.cast(this.address + offset);
    }

    @Override
    public J9HashTablePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9HashTablePointer sub(long count) {
        return J9HashTablePointer.cast(this.address - J9HashTable.SIZEOF * count);
    }

    @Override
    public J9HashTablePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9HashTablePointer subOffset(long offset) {
        return J9HashTablePointer.cast(this.address - offset);
    }

    @Override
    public J9HashTablePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9HashTablePointer untag(long mask) {
        return J9HashTablePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9HashTablePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9HashTable.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_entrySizeOffset_", declaredType="U32")
    public U32 entrySize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._entrySizeOffset_));
    }

    public U32Pointer entrySizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._entrySizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
    public U32 flags() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._flagsOffset_));
    }

    public U32Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_functionUserDataOffset_", declaredType="void*")
    public VoidPointer functionUserData() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9HashTable._functionUserDataOffset_));
    }

    public PointerPointer functionUserDataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._functionUserDataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_hashEqualFnOffset_", declaredType="void*")
    public VoidPointer hashEqualFn() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9HashTable._hashEqualFnOffset_));
    }

    public PointerPointer hashEqualFnEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._hashEqualFnOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_hashFnOffset_", declaredType="void*")
    public VoidPointer hashFn() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9HashTable._hashFnOffset_));
    }

    public PointerPointer hashFnEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._hashFnOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nodeAlignmentOffset_", declaredType="U32")
    public U32 nodeAlignment() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._nodeAlignmentOffset_));
    }

    public U32Pointer nodeAlignmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._nodeAlignmentOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nodePoolOffset_", declaredType="struct J9Pool*")
    public J9PoolPointer nodePool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9HashTable._nodePoolOffset_);
        return J9PoolPointer.cast(pointer);
    }

    public PointerPointer nodePoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._nodePoolOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nodeSizeOffset_", declaredType="U32")
    public U32 nodeSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._nodeSizeOffset_));
    }

    public U32Pointer nodeSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._nodeSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nodesOffset_", declaredType="void**")
    public PointerPointer nodes() throws CorruptDataException {
        return PointerPointer.cast(this.getPointerAtOffset(J9HashTable._nodesOffset_));
    }

    public PointerPointer nodesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._nodesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfNodesOffset_", declaredType="U32")
    public U32 numberOfNodes() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._numberOfNodesOffset_));
    }

    public U32Pointer numberOfNodesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._numberOfNodesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_portLibraryOffset_", declaredType="struct J9PortLibrary*")
    public J9PortLibraryPointer portLibrary() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9HashTable._portLibraryOffset_);
        return J9PortLibraryPointer.cast(pointer);
    }

    public PointerPointer portLibraryEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._portLibraryOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_printFnOffset_", declaredType="void*")
    public VoidPointer printFn() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9HashTable._printFnOffset_));
    }

    public PointerPointer printFnEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._printFnOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tableNameOffset_", declaredType="char*")
    public U8Pointer tableName() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(J9HashTable._tableNameOffset_));
    }

    public PointerPointer tableNameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._tableNameOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tableSizeOffset_", declaredType="U32")
    public U32 tableSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._tableSizeOffset_));
    }

    public U32Pointer tableSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._tableSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_treeNodePoolOffset_", declaredType="struct J9Pool*")
    public J9PoolPointer treeNodePool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9HashTable._treeNodePoolOffset_);
        return J9PoolPointer.cast(pointer);
    }

    public PointerPointer treeNodePoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._treeNodePoolOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_treeNodeSizeOffset_", declaredType="U32")
    public U32 treeNodeSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9HashTable._treeNodeSizeOffset_));
    }

    public U32Pointer treeNodeSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9HashTable._treeNodeSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_treePoolOffset_", declaredType="struct J9Pool*")
    public J9PoolPointer treePool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9HashTable._treePoolOffset_);
        return J9PoolPointer.cast(pointer);
    }

    public PointerPointer treePoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9HashTable._treePoolOffset_);
    }
}

