/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

public class U32Pointer
extends Pointer {
    public static final int SIZEOF = 4;
    public static final U32Pointer NULL = new U32Pointer(0L);

    protected U32Pointer(long address) {
        super(address);
    }

    public static U32Pointer cast(AbstractPointer pointer) {
        return U32Pointer.cast(pointer.getAddress());
    }

    public static U32Pointer cast(UDATA udata) {
        return U32Pointer.cast(udata.longValue());
    }

    public static U32Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new U32Pointer(address);
    }

    @Override
    public U32 at(long index) throws CorruptDataException {
        return new U32(this.getIntAtOffset(index * 4L));
    }

    @Override
    public U32 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public U32Pointer untag() {
        return this.untag(3L);
    }

    @Override
    public U32Pointer untag(long mask) {
        return new U32Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U32Pointer add(long count) {
        return new U32Pointer(this.address + 4L * count);
    }

    @Override
    public U32Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public U32Pointer addOffset(long offset) {
        return new U32Pointer(this.address + offset);
    }

    @Override
    public U32Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public U32Pointer sub(long count) {
        return new U32Pointer(this.address - 4L * count);
    }

    @Override
    public U32Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public U32Pointer subOffset(long offset) {
        return new U32Pointer(this.address - offset);
    }

    @Override
    public U32Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

