/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

public class FloatPointer
extends Pointer {
    public static final int SIZEOF = 4;
    public static final FloatPointer NULL = new FloatPointer(0L);

    protected FloatPointer(long address) {
        super(address);
    }

    public static FloatPointer cast(AbstractPointer pointer) {
        return FloatPointer.cast(pointer.getAddress());
    }

    public static FloatPointer cast(UDATA udata) {
        return FloatPointer.cast(udata.longValue());
    }

    public static FloatPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new FloatPointer(address);
    }

    @Override
    public FloatPointer at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException("Use floatAt(long index)");
    }

    @Override
    public FloatPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public long longAt(long index) throws CorruptDataException {
        return (long)this.floatAt(index);
    }

    @Override
    public double doubleAt(long index) throws CorruptDataException {
        return this.floatAt(index);
    }

    @Override
    public float floatAt(long index) throws CorruptDataException {
        return this.getFloatAtOffset(index * 4L);
    }

    @Override
    public FloatPointer add(long count) {
        return new FloatPointer(this.address + 4L * count);
    }

    @Override
    public FloatPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public FloatPointer addOffset(long offset) {
        return new FloatPointer(this.address + offset);
    }

    @Override
    public FloatPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public FloatPointer sub(long count) {
        return new FloatPointer(this.address - 4L * count);
    }

    @Override
    public FloatPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public FloatPointer subOffset(long offset) {
        return new FloatPointer(this.address - offset);
    }

    @Override
    public FloatPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public FloatPointer untag() {
        return this.untag(3L);
    }

    @Override
    public FloatPointer untag(long mask) {
        return new FloatPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

