/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

public class CorruptPointer
extends AbstractPointer {
    public static final long SIZEOF = process.bytesPerPointer();
    public static final CorruptPointer NULL = new CorruptPointer(0L);
    private String message;

    protected CorruptPointer(long address) {
        super(address);
    }

    public CorruptPointer(String message2, long address) {
        this(address);
        this.message = message2;
    }

    public static CorruptPointer cast(AbstractPointer pointer) {
        return CorruptPointer.cast(pointer.getAddress());
    }

    public static CorruptPointer cast(UDATA udata) {
        return CorruptPointer.cast(udata.longValue());
    }

    public static CorruptPointer cast(long address) {
        return new CorruptPointer(address);
    }

    @Override
    public CorruptPointer at(long index) throws CorruptDataException {
        throw new NullPointerDereference("Can not dereference a CorruptPointer");
    }

    @Override
    public CorruptPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public AbstractPointer add(long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPointer add(Scalar count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CorruptPointer addOffset(long offset) {
        return new CorruptPointer(this.message, this.address + offset);
    }

    @Override
    public CorruptPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public CorruptPointer untag(long tagBits) {
        return new CorruptPointer(this.message, this.address & tagBits);
    }

    @Override
    public AbstractPointer subOffset(long offset) {
        return new CorruptPointer(this.message, this.address - offset);
    }

    @Override
    public AbstractPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public AbstractPointer sub(long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPointer sub(Scalar count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPointer untag() {
        throw new UnsupportedOperationException();
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected long sizeOfBaseType() {
        throw new UnsupportedOperationException();
    }
}

