/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.walkers.HeapWalker;
import com.ibm.j9ddr.vm23.pointer.generated.J9AbstractThreadPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadMonitorPoolPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.structure.J9ThreadMonitorPool;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorIterator
implements Iterator {
    private static final long freeTag = new UDATA(-1L).longValue();
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private J9ThreadMonitorPoolPointer pool;
    private int index = 0;
    private J9ThreadMonitorPointer poolEntries;
    private int poolSize = 0;
    private Object current;
    private boolean walkThreadPool = true;
    private final Iterator flatMonitorIterator;
    private boolean EOI = false;

    public MonitorIterator(J9JavaVMPointer vm) throws CorruptDataException {
        J9AbstractThreadPointer ptr = this.getThreadLibrary(vm);
        J9ThreadLibraryPointer lib = ptr.library();
        this.log.fine(String.format("Thread library 0x%016x", lib.getAddress()));
        this.pool = lib.monitor_pool();
        if (this.pool.notNull()) {
            this.poolEntries = this.pool.entriesEA();
            this.poolSize = (int)J9ThreadMonitorPool.MONITOR_POOL_SIZE;
        }
        this.flatMonitorIterator = HeapWalker.getFlatLockedMonitors().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.EOI) {
            return false;
        }
        boolean result = false;
        try {
            if (this.walkThreadPool) {
                this.walkThreadPool = result = this.threadPoolHasNext();
            }
            if (!this.walkThreadPool && (result = this.flatMonitorIterator.hasNext()) && this.current == null) {
                this.current = this.flatMonitorIterator.next();
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Could not locate the next monitor", e, true);
            this.EOI = true;
        }
        return this.current != null || result;
    }

    private boolean threadPoolHasNext() throws CorruptDataException {
        while (this.current == null && this.pool.notNull()) {
            while (this.index < this.poolSize) {
                J9ObjectPointer obj;
                J9ThreadAbstractMonitorPointer thread;
                J9ThreadMonitorPointer monitor = J9ThreadMonitorPointer.cast(this.poolEntries.add(this.index));
                ++this.index;
                if (freeTag == monitor.count().longValue() || !(thread = J9ThreadAbstractMonitorPointer.cast(monitor)).userData().eq(0L) && !(obj = J9ObjectPointer.cast(thread.userData())).monitor().eq(monitor.getAddress() | 1L)) continue;
                this.current = monitor;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.format("Found monitor @ 0x%016x : %s", monitor.getAddress(), monitor.name().getCStringAtOffset(0L)));
                }
                return true;
            }
            this.pool = this.pool.next();
            if (!this.pool.notNull()) continue;
            this.index = 0;
            this.poolEntries = this.pool.entriesEA();
        }
        return this.pool.notNull();
    }

    public Object next() {
        if (this.hasNext()) {
            Object retval = this.current;
            this.current = null;
            return retval;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }

    private J9AbstractThreadPointer getThreadLibrary(J9JavaVMPointer vm) throws CorruptDataException {
        J9AbstractThreadPointer ptr;
        J9VMThreadPointer remoteThread = vm.mainThread();
        if (remoteThread.notNull() && (ptr = J9AbstractThreadPointer.cast(remoteThread.osThread())).notNull()) {
            return ptr;
        }
        throw new CorruptDataException("Cannot locate thread library");
    }
}

