/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm23.structure.J9RAMConstantPoolItem;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstantPoolIterator
implements Iterator<J9ObjectPointer> {
    private static final long J9DescriptionCpTypeObject = 1L;
    private static final long J9DescriptionCpTypeClass = 2L;
    private static final long J9DescriptionCpTypeMask = 3L;
    private final J9ClassPointer clazz;
    private int indexSize;
    private PointerPointer endPtr;
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private PointerPointer scanPtr = null;
    private int descriptionIndex = 0;
    private long descriptionBits = 0L;
    private U32Pointer descriptionPtr = null;
    private J9ObjectPointer nextObject = null;
    private long count = 0L;
    private boolean EOI = false;

    public ConstantPoolIterator(J9ClassPointer ptr) {
        this.clazz = ptr;
        try {
            J9ROMClassPointer romClazz = this.clazz.romClass();
            this.descriptionPtr = romClazz.cpShapeDescription();
            this.scanPtr = PointerPointer.cast(J9ClassHelper.ramConstantPool(this.clazz));
            this.endPtr = PointerPointer.cast(this.scanPtr.longValue() + romClazz.ramConstantPoolCount().longValue() * J9RAMConstantPoolItem.SIZEOF);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.format("Created constant pool iterator for J9Class %s : 0x%016x", J9ClassHelper.getName(this.clazz), this.clazz.getAddress()));
                this.log.fine(String.format("Pool start = 0x%016x", this.scanPtr.getAddress()));
                this.log.fine(String.format("Pool end = 0x%016x", this.endPtr.getAddress()));
            }
            this.indexSize = 15;
            if (this.scanPtr.lt(this.endPtr)) {
                this.getNextDescription();
                this.findNext();
            }
        }
        catch (CorruptDataException e) {
            this.EOI = true;
            EventManager.raiseCorruptDataEvent("Could not set the constant pool", e, true);
        }
    }

    private void getNextDescription() throws CorruptDataException {
        this.descriptionBits = this.descriptionPtr.at(0L).longValue();
        this.descriptionIndex = this.indexSize;
    }

    private void findNext() throws CorruptDataException {
        this.nextObject = null;
        while (this.nextObject == null && this.scanPtr.lt(this.endPtr)) {
            VoidPointer slotPtr;
            long slot = this.descriptionBits & 3L;
            if ((slot == 2L || slot == 1L) && (slotPtr = this.scanPtr.at(0L)).notNull()) {
                this.log.fine(String.format("Found slot entry %d : 0x%016x -> 0x%016x", this.count++, this.scanPtr.getAddress(), slotPtr.getAddress()));
                this.nextObject = J9ObjectPointer.cast(slotPtr);
            }
            this.scanPtr = this.scanPtr.add(1L);
            this.descriptionBits >>= 2;
            if (this.descriptionIndex-- != 0) continue;
            this.descriptionPtr = this.descriptionPtr.add(1L);
            this.getNextDescription();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.EOI && this.nextObject != null;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer retval = this.nextObject;
            try {
                this.findNext();
            }
            catch (CorruptDataException e) {
                this.EOI = true;
                EventManager.raiseCorruptDataEvent("Could not determine next item in the constant pool", e, true);
            }
            return retval;
        }
        throw new NoSuchElementException("There are no more elements in this iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }
}

