/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9HashTablePointer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class ClassIterator
implements Iterator<J9ClassPointer> {
    protected static final Logger logger = Logger.getLogger("j9ddr.walkers");
    private final Iterator<J9ClassPointer> iterator;
    private J9ClassPointer next = null;

    protected ClassIterator(Iterator<J9ClassPointer> iterator) {
        this.iterator = iterator;
        this.setNextItem();
    }

    public static Iterator<J9ClassPointer> fromJ9Classloader(J9ClassLoaderPointer loader) throws CorruptDataException {
        J9HashTablePointer table = loader.classHashTable();
        Iterator<J9ClassPointer> iterator = null;
        switch (AlgorithmVersion.getVMMinorVersion()) {
            default: 
        }
        logger.fine("Creating version 2.3.0 class walker");
        iterator = Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator();
        return new ClassIterator(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void setNextItem() {
        this.next = null;
        if (this.iterator.hasNext()) {
            switch (AlgorithmVersion.getVMMinorVersion()) {
                default: 
            }
            this.next = this.iterator.next();
        }
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            J9ClassPointer ptr = this.next;
            this.setNextItem();
            return ptr;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

