/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JNIReferenceFramePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GCVMThreadJNISlotIterator
extends GCIterator {
    protected J9JNIReferenceFramePointer jniFrame;
    protected Iterator<PointerPointer> poolIterator;

    protected GCVMThreadJNISlotIterator(J9VMThreadPointer vmThread) throws CorruptDataException {
        this.jniFrame = J9JNIReferenceFramePointer.cast(vmThread.jniLocalReferences());
        this.poolIterator = null;
    }

    public static GCVMThreadJNISlotIterator fromJ9VMThread(J9VMThreadPointer vmThread) throws CorruptDataException {
        return new GCVMThreadJNISlotIterator(vmThread);
    }

    @Override
    public boolean hasNext() {
        if (this.jniFrame.isNull()) {
            return false;
        }
        if (null == this.poolIterator) {
            try {
                J9PoolPointer poolPtr = J9PoolPointer.cast(this.jniFrame.references());
                this.poolIterator = Pool.fromJ9Pool(poolPtr, PointerPointer.class).iterator();
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error looking at current frame", cde, false);
                try {
                    this.jniFrame = this.jniFrame.previous();
                    this.poolIterator = null;
                    return this.hasNext();
                }
                catch (CorruptDataException cde2) {
                    EventManager.raiseCorruptDataEvent("Error looking at previous frame", cde2, true);
                    return false;
                }
            }
        }
        if (this.poolIterator.hasNext()) {
            return true;
        }
        try {
            this.jniFrame = this.jniFrame.previous();
            this.poolIterator = null;
            return this.hasNext();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error moving to previous frame", e, true);
            return false;
        }
    }

    public J9ObjectPointer next() {
        if (this.hasNext()) {
            try {
                PointerPointer next = this.poolIterator.next();
                return J9ObjectPointer.cast(next.at(0L));
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

