/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import java.util.NoSuchElementException;

public class GCVMClassSlotIterator
extends GCIterator {
    protected PointerPointer scanPtr;
    protected PointerPointer endPtr;

    protected GCVMClassSlotIterator(J9JavaVMPointer vm) throws CorruptDataException {
        this.scanPtr = vm.voidReflectClassEA();
        this.endPtr = vm.knownClassesEA().add(65L);
    }

    public static GCVMClassSlotIterator fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        return new GCVMClassSlotIterator(vm);
    }

    @Override
    public boolean hasNext() {
        return this.scanPtr.lt(this.endPtr);
    }

    public J9ClassPointer next() {
        try {
            if (this.hasNext()) {
                J9ClassPointer next = J9ClassPointer.cast(this.scanPtr.at(0L));
                this.scanPtr = this.scanPtr.add(1L);
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }
}

