/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class GCObjectHeapIteratorAddressOrderedList_V1
extends GCObjectHeapIterator {
    protected J9ObjectPointer currentObject = null;
    protected U8Pointer scanPtr;
    protected U8Pointer scanPtrTop;
    protected U8Pointer[][] tlhRanges;
    protected int currentTLHRange;

    protected GCObjectHeapIteratorAddressOrderedList_V1(J9JavaVMPointer vm, J9MemorySegmentPointer segment, boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        super(vm, segment, includeLiveObjects, includeDeadObjects);
        this.scanPtr = segment.heapBase();
        this.scanPtrTop = segment.heapAlloc();
        ArrayList<U8Pointer[]> tlhRangeList = new ArrayList<U8Pointer[]>();
        GCVMThreadListIterator threadIterator = new GCVMThreadListIterator(vm);
        while (threadIterator.hasNext()) {
            J9VMThreadPointer vmThread = threadIterator.next();
            if (!J9BuildFlags.gc_inlinedAllocFields || vmThread.heapAlloc().equals(vmThread.heapTop())) continue;
            tlhRangeList.add(new U8Pointer[]{vmThread.heapAlloc(), vmThread.heapTop()});
        }
        tlhRangeList.add(new U8Pointer[]{this.scanPtrTop, this.scanPtrTop});
        Collections.sort(tlhRangeList, new Comparator<U8Pointer[]>(){

            @Override
            public int compare(U8Pointer[] o1, U8Pointer[] o2) {
                return o1[0].compare(o2[0]);
            }
        });
        this.tlhRanges = new U8Pointer[tlhRangeList.size()][2];
        tlhRangeList.toArray((T[])this.tlhRanges);
        this.currentTLHRange = 0;
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.currentObject) {
                return true;
            }
            while (this.scanPtr.lt(this.scanPtrTop)) {
                while (this.scanPtr.gt(this.tlhRanges[this.currentTLHRange][1])) {
                    ++this.currentTLHRange;
                }
                if (this.scanPtr.gte(this.tlhRanges[this.currentTLHRange][0])) {
                    this.scanPtr = U8Pointer.cast(this.tlhRanges[this.currentTLHRange][1]);
                    ++this.currentTLHRange;
                    continue;
                }
                this.currentObject = J9ObjectPointer.cast(this.scanPtr);
                if (!this.objectModel.isDeadObject(this.currentObject)) {
                    this.scanPtr = this.scanPtr.add(this.objectModel.getConsumedSizeInBytesWithHeader(this.currentObject));
                    if (!this.includeLiveObjects) continue;
                    return true;
                }
                long deadObjectSize = this.objectModel.isSingleSlotDeadObject(this.currentObject) ? this.objectModel.getSizeInBytesSingleSlotDeadObject(this.currentObject).longValue() : this.objectModel.getSizeInBytesMultiSlotDeadObject(this.currentObject).longValue();
                if (deadObjectSize == 0L) {
                    throw new CorruptDataException("Dead object at " + this.currentObject.getHexAddress() + " has an invalid size of 0");
                }
                this.scanPtr = this.scanPtr.add(deadObjectSize);
                if (!this.includeDeadObjects) continue;
                return true;
            }
            return false;
        }
        catch (CorruptDataException e) {
            this.currentObject = null;
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return false;
        }
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer next = this.currentObject;
            this.currentObject = null;
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

