/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.GC_FinalizeListPointer;
import com.ibm.j9ddr.vm23.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm23.structure.GC_FinalizerJob$Type;
import java.util.NoSuchElementException;

public class GCFinalizeListSlotIterator
extends GCIterator {
    GC_FinalizerJobPointer scanPtr;
    GC_FinalizerJobPointer endPtr;
    boolean includeNonObjectJobs;

    protected GCFinalizeListSlotIterator(GC_FinalizeListPointer list, boolean includeNonObjectJobs) throws CorruptDataException {
        this.scanPtr = list._leadingUsed();
        this.endPtr = list._leadingFree();
        this.includeNonObjectJobs = includeNonObjectJobs;
    }

    public static GCFinalizeListSlotIterator fromFinalizeList(GC_FinalizeListPointer list) throws CorruptDataException {
        return new GCFinalizeListSlotIterator(list, false);
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.scanPtr.lt(this.endPtr)) {
                GC_FinalizerJobPointer current = this.scanPtr;
                if (!current._type().eq(GC_FinalizerJob$Type.NULL_JOB) && (this.includeNonObjectJobs || current._type().longValue() != GC_FinalizerJob$Type.FREE_CLASS_LOADER)) {
                    return true;
                }
                this.scanPtr = this.scanPtr.add(1L);
            }
            return false;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return false;
        }
    }

    public GC_FinalizerJobPointer next() {
        if (this.hasNext()) {
            GC_FinalizerJobPointer next = this.scanPtr;
            this.scanPtr = this.scanPtr.add(1L);
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

