/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ClassHelper;
import java.util.ArrayList;
import java.util.Iterator;

public class GCConstantPoolSlotIterator
extends GCIterator {
    protected Iterator<AbstractPointer> iterator;
    public static final long J9DescriptionCpTypeClass = 2L;
    public static final long J9DescriptionCpTypeEA = 3L;
    public static final long J9DescriptionCpTypeMask = 3L;
    public static final long J9DescriptionCpTypeObject = 1L;
    public static final long J9DescriptionCpTypeScalar = 0L;
    public static final long J9_CP_DESCRIPTIONS_PER_U32 = 16L;

    protected GCConstantPoolSlotIterator(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        this.initializeSlots_V1(clazz, returnClassSlots, returnObjectSlots);
    }

    protected void initializeSlots_V1(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        U32Pointer cpDescriptionSlots = clazz.romClass().cpShapeDescription();
        PointerPointer cpEntry = PointerPointer.cast(J9ClassHelper.ramConstantPool(clazz));
        long cpDescription = 0L;
        long cpEntryCount = clazz.romClass().ramConstantPoolCount().longValue();
        long cpDescriptionIndex = 0L;
        ArrayList<StructurePointer> slots = new ArrayList<StructurePointer>();
        while (cpEntryCount > 0L) {
            StructurePointer slot;
            long slotType;
            if (0L == cpDescriptionIndex) {
                cpDescription = cpDescriptionSlots.at(0L).longValue();
                cpDescriptionSlots = cpDescriptionSlots.add(1L);
                cpDescriptionIndex = 16L;
            }
            if ((slotType = cpDescription & 3L) == 1L) {
                if (returnObjectSlots && (slot = J9ObjectPointer.cast(cpEntry.at(0L))).notNull()) {
                    slots.add(slot);
                }
            } else if (slotType == 2L && returnClassSlots && (slot = J9ClassPointer.cast(cpEntry.at(0L))).notNull()) {
                slots.add(slot);
            }
            cpEntry = cpEntry.add(1L);
            --cpEntryCount;
            cpDescription >>= 2;
            --cpDescriptionIndex;
        }
        this.iterator = slots.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public AbstractPointer next() {
        return this.iterator.next();
    }

    public static GCConstantPoolSlotIterator fromJ9Class(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        return new GCConstantPoolSlotIterator(clazz, returnClassSlots, returnObjectSlots);
    }
}

