/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import java.util.NoSuchElementException;

public class GCClassSuperclassesIterator
extends GCIterator {
    protected PointerPointer superclasses;
    protected int classDepth;
    protected int index;

    protected GCClassSuperclassesIterator(J9ClassPointer clazz) throws CorruptDataException {
        this.superclasses = clazz.superclasses();
        this.classDepth = clazz.classDepthAndFlags().bitAnd(J9Consts.J9_JAVA_CLASS_DEPTH_MASK).intValue();
        this.index = 0;
    }

    public static GCClassSuperclassesIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassSuperclassesIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        if (0 == this.classDepth) {
            return false;
        }
        return this.index < this.classDepth;
    }

    public J9ClassPointer next() {
        if (this.hasNext()) {
            try {
                J9ClassPointer next = J9ClassPointer.cast(this.superclasses.at(this.index));
                ++this.index;
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

