/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassStaticsIterator
extends GCIterator {
    Iterator<J9ObjectPointer> iterator;

    protected GCClassStaticsIterator(J9ClassPointer clazz) throws CorruptDataException {
        ArrayList<J9ObjectPointer> statics = new ArrayList<J9ObjectPointer>();
        UDATAPointer staticPtr = clazz.ramStatics();
        for (long objectStaticCount = clazz.romClass().objectStaticCount().longValue(); objectStaticCount > 0L; --objectStaticCount) {
            UDATA slot = staticPtr.at(0L);
            if (!slot.eq(0L)) {
                statics.add(J9ObjectPointer.cast(slot));
            }
            staticPtr = staticPtr.add(1L);
        }
        this.iterator = statics.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public J9ObjectPointer next() {
        return this.iterator.next();
    }

    public static GCClassStaticsIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassStaticsIterator(clazz);
    }
}

