/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCClassArrayClassSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCClassLocalInterfaceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCClassSuperclassesIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCConstantPoolClassSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import java.util.NoSuchElementException;

public class GCClassIteratorClassSlots
extends GCIterator {
    protected static final int state_start = 0;
    protected static final int state_constant_pool = 1;
    protected static final int state_superclasses = 2;
    protected static final int state_interfaces = 3;
    protected static final int state_array_class_slots = 4;
    protected static final int state_end = 5;
    protected int state = 0;
    protected GCConstantPoolClassSlotIterator constantPoolSlotIterator;
    protected GCClassSuperclassesIterator superclassesIterator;
    protected GCClassLocalInterfaceIterator localInterfacesIterator;
    protected GCClassArrayClassSlotIterator arrayClassSlotIterator;

    protected GCClassIteratorClassSlots(J9ClassPointer clazz) throws CorruptDataException {
        this.constantPoolSlotIterator = GCConstantPoolClassSlotIterator.fromJ9Class(clazz);
        this.superclassesIterator = GCClassSuperclassesIterator.fromJ9Class(clazz);
        this.localInterfacesIterator = GCClassLocalInterfaceIterator.fromJ9Class(clazz);
        this.arrayClassSlotIterator = GCClassArrayClassSlotIterator.fromJ9Class(clazz);
    }

    public static GCClassIteratorClassSlots fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassIteratorClassSlots(clazz);
    }

    @Override
    public boolean hasNext() {
        if (this.state == 5) {
            return false;
        }
        switch (this.state) {
            case 0: {
                ++this.state;
            }
            case 1: {
                if (this.constantPoolSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 2: {
                if (this.superclassesIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 3: {
                if (this.localInterfacesIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 4: {
                if (this.arrayClassSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
        }
        return false;
    }

    public J9ClassPointer next() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.constantPoolSlotIterator.next();
                }
                case 2: {
                    return this.superclassesIterator.next();
                }
                case 3: {
                    return this.localInterfacesIterator.next();
                }
                case 4: {
                    return this.arrayClassSlotIterator.next();
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

