/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCClassStaticsIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCConstantPoolObjectSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCClassIterator
extends GCIterator {
    protected static final int state_start = 0;
    protected static final int state_statics = 1;
    protected static final int state_constant_pool = 2;
    protected static final int state_slots = 3;
    protected static final int state_end = 4;
    protected int state = 0;
    protected GCClassStaticsIterator staticsIterator;
    protected GCConstantPoolObjectSlotIterator constantPoolSlotIterator;

    protected GCClassIterator(J9ClassPointer clazz) throws CorruptDataException {
        this.staticsIterator = GCClassStaticsIterator.fromJ9Class(clazz);
        this.constantPoolSlotIterator = GCConstantPoolObjectSlotIterator.fromJ9Class(clazz);
    }

    public static GCClassIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        if (this.state == 4) {
            return false;
        }
        switch (this.state) {
            case 0: {
                ++this.state;
            }
            case 1: {
                if (this.staticsIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 2: {
                if (this.constantPoolSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 3: {
                ++this.state;
            }
        }
        return false;
    }

    public J9ObjectPointer next() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.staticsIterator.next();
                }
                case 2: {
                    return this.constantPoolSlotIterator.next();
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

