/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.HashTable;
import com.ibm.j9ddr.vm23.j9.StringTable;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringTable_V1
extends StringTable {
    protected HashTable<PointerPointer> stringTable;

    protected StringTable_V1(HashTable<PointerPointer> hashTable) throws CorruptDataException {
        this.stringTable = hashTable;
    }

    public static StringTable fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        HashTable<PointerPointer> hashTable = HashTable.fromJ9HashTable(vm.stringTable(), PointerPointer.class, new StringEqualFunction(), new StringHashFunction());
        return new StringTable_V1(hashTable);
    }

    @Override
    public Iterator<J9ObjectPointer> iterator() {
        return new Iterator<J9ObjectPointer>(){
            Iterator<PointerPointer> stringTableIterator;
            {
                this.stringTableIterator = StringTable_V1.this.stringTable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.stringTableIterator.hasNext();
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    try {
                        PointerPointer next = this.stringTableIterator.next();
                        return J9ObjectPointer.cast(next.at(0L));
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                this.stringTableIterator.remove();
            }
        };
    }

    @Override
    public long getCount() {
        return this.stringTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.stringTable.getTableName();
    }

    @Override
    public J9ObjectPointer search(J9ObjectPointer objectPointer) throws CorruptDataException {
        throw new UnsupportedOperationException("Search is not supported in StringTable_V1");
    }

    public static class StringHashFunction
    implements HashTable.HashFunction<PointerPointer> {
        @Override
        public UDATA hash(PointerPointer entry) {
            try {
                J9ObjectPointer entryObject = J9ObjectPointer.cast(entry.at(0L));
                return new UDATA(J9ObjectHelper.stringValue(entryObject).hashCode());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }
    }

    public static class StringEqualFunction
    implements HashTable.HashEqualFunction<PointerPointer> {
        @Override
        public boolean equal(PointerPointer left, PointerPointer right) {
            try {
                J9ObjectPointer leftObject = J9ObjectPointer.cast(left.at(0L));
                J9ObjectPointer rightObject = J9ObjectPointer.cast(right.at(0L));
                return J9ObjectHelper.stringValue(leftObject).equals(J9ObjectHelper.stringValue(rightObject));
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }
}

