/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm23.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm23.j9.IAlgorithm;
import com.ibm.j9ddr.vm23.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.structure.J9ExceptionHandler;
import com.ibm.j9ddr.vm23.structure.J9ExceptionInfo;
import com.ibm.j9ddr.vm23.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm23.structure.J9ROMMethod;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.U8;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.LinkedList;

public class ROMHelp {
    private static final AlgorithmPicker<IROMHelpImpl> picker = new AlgorithmPicker<IROMHelpImpl>("ALG_ROM_HELP_VERSION"){

        @Override
        protected Iterable<? extends IROMHelpImpl> allAlgorithms() {
            LinkedList<ROMHelp_23_V0> list = new LinkedList<ROMHelp_23_V0>();
            list.add(new ROMHelp_23_V0());
            return list;
        }
    };
    private static IROMHelpImpl impl;

    private static IROMHelpImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().getOriginalROMMethod(method);
    }

    public static J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().nextROMMethod(romMethod);
    }

    public static SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer info) throws CorruptDataException {
        return ROMHelp.getImpl().J9EXCEPTIONINFO_THROWNAMES(info);
    }

    public static J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer info) throws CorruptDataException {
        return ROMHelp.getImpl().J9EXCEPTIONINFO_HANDLERS(info);
    }

    public static J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
    }

    public static U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(romMethod);
    }

    public static UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
    }

    public static UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
    }

    public static U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_BYTECODE_START_FROM_ROM_METHOD(method);
    }

    public static J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ROM_METHOD_FROM_RAM_METHOD(method);
    }

    public static J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_CLASS_FROM_METHOD(method);
    }

    public static U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ARG_COUNT_FROM_ROM_METHOD(method);
    }

    public static U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_TEMP_COUNT_FROM_ROM_METHOD(method);
    }

    public static J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9ROMMETHOD_SIGNATURE(method);
    }

    private static class ROMHelp_23_V0
    extends BaseAlgorithm
    implements IROMHelpImpl {
        protected ROMHelp_23_V0() {
            super(30, 0);
        }

        @Override
        public J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer method) throws CorruptDataException {
            J9ClassPointer methodClass = this.J9_CLASS_FROM_METHOD(method);
            J9ROMClassPointer romClass = methodClass.romClass();
            J9ROMMethodPointer romMethod = this.J9_ROM_METHOD_FROM_RAM_METHOD(method);
            U8Pointer bytecodes = this.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            if (bytecodes.lt(romClass) || bytecodes.gte(romClass.addOffset(romClass.romSize()))) {
                romMethod = romClass.romMethods();
                for (long methodIndex = UDATA.cast(method).sub(UDATA.cast(methodClass.ramMethods())).longValue(); methodIndex > 0L; --methodIndex) {
                    romMethod = this.nextROMMethod(romMethod);
                }
            }
            return romMethod;
        }

        @Override
        public J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            J9ExceptionInfoPointer exceptionInfo = this.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            J9ROMMethodPointer result = romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo) ? J9ROMMethodPointer.cast(this.J9EXCEPTIONINFO_THROWNAMES(exceptionInfo).add(exceptionInfo.throwCount())) : J9ROMMethodPointer.cast(exceptionInfo);
            return result;
        }

        @Override
        public SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer info) throws CorruptDataException {
            return SelfRelativePointer.cast(this.J9EXCEPTIONINFO_HANDLERS(info).addOffset(new U32(info.catchCount()).mult((int)J9ExceptionHandler.SIZEOF)));
        }

        @Override
        public J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer info) throws CorruptDataException {
            return J9ExceptionHandlerPointer.cast(info.addOffset(J9ExceptionInfo.SIZEOF));
        }

        @Override
        public J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            U32Pointer sigAddr = this.J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(romMethod);
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasGenericSignature)) {
                sigAddr = sigAddr.add(1L);
            }
            return J9ExceptionInfoPointer.cast(sigAddr);
        }

        @Override
        public U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            return U32Pointer.cast(this.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod).addOffset(this.J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod)));
        }

        @Override
        public UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            return this.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod).add(3L).bitAnd(new UDATA(3L).bitNot());
        }

        @Override
        public UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            UDATA byteCodeSlots = new UDATA(romMethod.bytecodeSlots());
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccLargeMethod)) {
                UDATA bytecodeSlotsHigh = new UDATA(romMethod.bytecodeSlotsHigh());
                bytecodeSlotsHigh = bytecodeSlotsHigh.leftShift(16);
                byteCodeSlots = byteCodeSlots.add(bytecodeSlotsHigh);
            }
            return byteCodeSlots.mult(4);
        }

        @Override
        public U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return U8Pointer.cast(method).add(J9ROMMethod.SIZEOF);
        }

        @Override
        public J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer method) throws CorruptDataException {
            return J9ROMMethodPointer.cast(method.bytecodes().sub(J9ROMMethod.SIZEOF));
        }

        @Override
        public J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
            J9ConstantPoolPointer cp = method.constantPool().untag(J9Consts.J9_STARTPC_STATUS);
            return cp.ramClass();
        }

        @Override
        public U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return method.argCount();
        }

        @Override
        public U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return method.tempCount();
        }

        @Override
        public J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer method) throws CorruptDataException {
            return method.nameAndSignature().signature();
        }
    }

    private static interface IROMHelpImpl
    extends IAlgorithm {
        public J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer var1) throws CorruptDataException;

        public J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer var1) throws CorruptDataException;

        public J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer var1) throws CorruptDataException;

        public J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer var1) throws CorruptDataException;

        public J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer var1) throws CorruptDataException;

        public U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer var1) throws CorruptDataException;
    }
}

