/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9PoolPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Pool_23_V0<StructType extends DataType>
extends Pool<StructType> {
    private final boolean isInline;

    protected <T extends DataType> Pool_23_V0(J9PoolPointer structure, Class<T> structType, boolean isInline) throws CorruptDataException {
        super(structure, structType);
        this.isInline = isInline;
    }

    @Override
    public long numElements() {
        try {
            J9PoolPointer aPool = this.pool;
            long numElements = 0L;
            while (aPool.notNull()) {
                numElements += aPool.usedElements().longValue();
                aPool = aPool.nextPool();
            }
            return numElements;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Unable to determine number of pool elements", cde, true);
            return 0L;
        }
    }

    @Override
    public boolean includesElement(StructType anElement) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Iterator<StructType> iterator() {
        return new Iterator<StructType>(){
            private J9PoolPointer puddle;
            private ArrayList<VoidPointer> items;
            int currentItem;
            {
                this.puddle = Pool_23_V0.this.pool;
                this.currentItem = -1;
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.puddle.isNull()) {
                        return false;
                    }
                    if (-1 == this.currentItem) {
                        VoidPointer firstElement = this.puddle.firstElementAddress();
                        int numElements = this.puddle.numberOfElements().intValue();
                        this.items = new ArrayList(numElements);
                        for (int i = 0; i < numElements; ++i) {
                            this.items.add(firstElement.addOffset(i * (int)Pool_23_V0.this.elementSize));
                        }
                        UDATAPointer currentFree = this.puddle.firstFreeSlot();
                        while (currentFree.notNull()) {
                            if (!this.items.remove(currentFree)) {
                                throw new RuntimeException();
                            }
                            currentFree = UDATAPointer.cast(currentFree.at(0L));
                        }
                        if (0 == this.items.size()) {
                            this.currentItem = -1;
                            this.puddle = this.puddle.nextPool();
                            return this.hasNext();
                        }
                        this.currentItem = 0;
                        return true;
                    }
                    if (this.currentItem >= this.items.size()) {
                        this.currentItem = -1;
                        this.puddle = this.puddle.nextPool();
                        return this.hasNext();
                    }
                    return true;
                }
                catch (CorruptDataException cde) {
                    EventManager.raiseCorruptDataEvent("Error finding next item", cde, true);
                    return false;
                }
            }

            @Override
            public StructType next() {
                if (this.hasNext()) {
                    try {
                        VoidPointer vptr = this.items.get(this.currentItem);
                        if (!Pool_23_V0.this.isInline) {
                            PointerPointer ptr = PointerPointer.cast(vptr);
                            vptr = ptr.at(0L);
                        }
                        DataType next = (DataType)DataType.getStructure(Pool_23_V0.this.structType.getSimpleName(), vptr.getAddress());
                        ++this.currentItem;
                        return next;
                    }
                    catch (CorruptDataException cde) {
                        ++this.currentItem;
                        EventManager.raiseCorruptDataEvent("Error finding next item", cde, true);
                        return this.next();
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The J9Pool is read only and cannot be modified.");
            }
        };
    }
}

