/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm23.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm23.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm23.j9.IAlgorithm;
import com.ibm.j9ddr.vm23.j9.ROMHelp;
import com.ibm.j9ddr.vm23.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.LinkedList;

public class OptInfo {
    private static IOptInfoImpl impl;
    private static final AlgorithmPicker<IOptInfoImpl> picker;

    private static IOptInfoImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
        return OptInfo.getImpl().getLineNumberForROMClass(method, relativePC);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoForROMClass(J9MethodPointer method) throws CorruptDataException {
        J9ConstantPoolPointer cp = ConstantPoolHelpers.J9_CP_FROM_METHOD(method);
        J9MethodPointer ramMethods = cp.ramClass().ramMethods();
        UDATA offset = new UDATA(method.sub(ramMethods));
        U32Pointer methodDebugInfoArray = OptInfo.getMethodDebugInfoArrayForROMClass(cp.ramClass().classLoader(), cp.ramClass().romClass());
        if (methodDebugInfoArray.isNull()) {
            return J9MethodDebugInfoPointer.NULL;
        }
        methodDebugInfoArray = methodDebugInfoArray.add(offset);
        return J9MethodDebugInfoPointer.cast(SelfRelativePointer.cast(methodDebugInfoArray).get());
    }

    public static U32Pointer getMethodDebugInfoArrayForROMClass(J9ClassLoaderPointer classLoader, J9ROMClassPointer romClass) throws CorruptDataException {
        if (J9BuildFlags.opt_debugInfoServer) {
            U32Pointer ptr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), J9Consts.J9_ROMCLASS_OPTINFO_METHOD_INFO);
            if (ptr.isNull()) {
                return U32Pointer.NULL;
            }
            return U32Pointer.cast(SelfRelativePointer.cast(ptr).get());
        }
        return U32Pointer.NULL;
    }

    public static J9LineNumberPointer getLineNumberTableForROMClass(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (!methodInfo.lineNumberCount().eq(0L)) {
            return J9LineNumberPointer.cast(methodInfo.add(1L));
        }
        return J9LineNumberPointer.NULL;
    }

    public static U32Pointer getSRPPtr(U32Pointer ptr, U32 flags, long option) {
        if (!flags.anyBitsIn(option) || ptr.isNull()) {
            return U32Pointer.NULL;
        }
        return ptr.add(OptInfo.countBits(OptInfo.COUNT_MASK(flags, option)) - 1);
    }

    public static int countBits(U32 word) {
        int count = 0;
        for (long x = word.longValue(); x != 0L; x >>= 1) {
            if ((x & 1L) == 0L) continue;
            ++count;
        }
        return count;
    }

    public static U32 COUNT_MASK(U32 value, long mask) {
        return value.bitAnd((mask << 1) - 1L);
    }

    public static String getSourceFileNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        U32Pointer ptr;
        if (J9BuildFlags.opt_debugInfoServer && (ptr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), J9Consts.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME)) != U32Pointer.NULL) {
            return J9UTF8Helper.stringValue(J9UTF8Pointer.cast(SelfRelativePointer.cast(ptr).get()));
        }
        return null;
    }

    static {
        picker = new AlgorithmPicker<IOptInfoImpl>("OPT_INFO_VERSION"){

            @Override
            protected Iterable<? extends IOptInfoImpl> allAlgorithms() {
                LinkedList<OptInfo_23_V0> list = new LinkedList<OptInfo_23_V0>();
                list.add(new OptInfo_23_V0());
                return list;
            }
        };
    }

    private static class OptInfo_23_V0
    extends BaseAlgorithm
    implements IOptInfoImpl {
        protected OptInfo_23_V0() {
            super(30, 0);
        }

        @Override
        public int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
            J9MethodDebugInfoPointer methodInfo;
            UDATA bytecodeSize = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method));
            int number = -1;
            if ((relativePC.lt(bytecodeSize) || bytecodeSize.eq(0L)) && (methodInfo = OptInfo.getMethodDebugInfoForROMClass(method)).notNull()) {
                J9LineNumberPointer currentLineNumber = OptInfo.getLineNumberTableForROMClass(methodInfo);
                J9LineNumberPointer lastLineNumber = J9LineNumberPointer.NULL;
                int i = 0;
                while ((long)i < methodInfo.lineNumberCount().longValue() && !relativePC.lt(currentLineNumber.location())) {
                    lastLineNumber = currentLineNumber;
                    currentLineNumber = currentLineNumber.add(1L);
                    ++i;
                }
                if (!lastLineNumber.eq(0)) {
                    number = lastLineNumber.lineNumber().intValue();
                }
            }
            return number;
        }
    }

    private static interface IOptInfoImpl
    extends IAlgorithm {
        public int getLineNumberForROMClass(J9MethodPointer var1, UDATA var2) throws CorruptDataException;
    }
}

