/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.HashTable;
import com.ibm.j9ddr.vm23.j9.IHashTable;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MonitorTable
implements IHashTable<J9ThreadAbstractMonitorPointer> {
    protected HashTable<PointerPointer> monitorTable;

    protected MonitorTable(HashTable<PointerPointer> hashTable) throws CorruptDataException {
        this.monitorTable = hashTable;
    }

    public static MonitorTable fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        HashTable.HashEqualFunction<PointerPointer> equalFunction = MonitorTable.getEqualFunction();
        HashTable.HashFunction<PointerPointer> hashFunction = MonitorTable.getHashFunction();
        HashTable<PointerPointer> hashTable = HashTable.fromJ9HashTable(vm.monitorTable(), PointerPointer.class, equalFunction, hashFunction);
        return new MonitorTable(hashTable);
    }

    private static HashTable.HashFunction<PointerPointer> getHashFunction() {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_MONITOR_HASH_FUNCTION_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorHashFunction_V1();
    }

    private static HashTable.HashEqualFunction<PointerPointer> getEqualFunction() {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_MONITOR_EQUAL_FUNCTION_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorEqualFunction_V1();
    }

    @Override
    public Iterator<J9ThreadAbstractMonitorPointer> iterator() {
        return new Iterator<J9ThreadAbstractMonitorPointer>(){
            Iterator<PointerPointer> monitorTableIterator;
            {
                this.monitorTableIterator = MonitorTable.this.monitorTable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.monitorTableIterator.hasNext();
            }

            @Override
            public J9ThreadAbstractMonitorPointer next() {
                if (this.hasNext()) {
                    try {
                        PointerPointer next = this.monitorTableIterator.next();
                        return J9ThreadAbstractMonitorPointer.cast(next.at(0L));
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                this.monitorTableIterator.remove();
            }
        };
    }

    @Override
    public long getCount() {
        return this.monitorTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.monitorTable.getTableName();
    }

    protected static class MonitorEqualFunction_V1
    implements HashTable.HashEqualFunction<PointerPointer> {
        protected MonitorEqualFunction_V1() {
        }

        @Override
        public boolean equal(PointerPointer entry1, PointerPointer entry2) {
            try {
                J9ThreadAbstractMonitorPointer entry1Monitor = J9ThreadAbstractMonitorPointer.cast(entry1.at(0L));
                J9ThreadAbstractMonitorPointer entry2Monitor = J9ThreadAbstractMonitorPointer.cast(entry2.at(0L));
                return entry1Monitor.userData().eq(entry2Monitor.userData());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }

    protected static class MonitorHashFunction_V1
    implements HashTable.HashFunction<PointerPointer> {
        protected static GCObjectModel objectModel;

        protected MonitorHashFunction_V1() {
        }

        @Override
        public UDATA hash(PointerPointer entry) {
            try {
                J9ThreadAbstractMonitorPointer entryMonitor = J9ThreadAbstractMonitorPointer.cast(entry.at(0L));
                J9ObjectPointer object = J9ObjectPointer.cast(entryMonitor.userData());
                return new UDATA(objectModel.getObjectHashCode(object));
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }

        static {
            try {
                objectModel = GCObjectModel.fromJ9JavaVM(J9RASHelper.getVM(DataType.getJ9RASPointer()));
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error initializing the object model", cde, true);
                objectModel = null;
            }
        }
    }
}

