/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AVLTree;
import com.ibm.j9ddr.vm23.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JITHashTablePointer;
import com.ibm.j9ddr.vm23.types.UDATA;

public class JITLook {
    private static PointerPointer DETERMINE_BUCKET(UDATA value, UDATA start, UDATAPointer buckets) {
        return PointerPointer.cast(new UDATA(value.sub(start).rightShift(9).longValue() * (long)UDATA.SIZEOF).add(UDATA.cast(buckets)));
    }

    public static J9JITExceptionTablePointer jit_artifact_search(J9AVLTreePointer tree, UDATA searchValue) throws CorruptDataException {
        AVLTree localTree = AVLTree.fromJ9AVLTreePointer(tree, new JITArtifactSearchCompare());
        J9JITHashTablePointer table = J9JITHashTablePointer.cast(localTree.search(searchValue));
        if (table.notNull()) {
            return JITLook.hash_jit_artifact_search(table, searchValue);
        }
        return J9JITExceptionTablePointer.NULL;
    }

    public static J9JITExceptionTablePointer hash_jit_artifact_search(J9JITHashTablePointer table, UDATA searchValue) throws CorruptDataException {
        PointerPointer bucket;
        if (searchValue.gte(table.start()) && searchValue.lt(table.end()) && (bucket = JITLook.DETERMINE_BUCKET(searchValue, table.start(), table.buckets())).at(0L).notNull()) {
            J9JITExceptionTablePointer entry;
            if (bucket.at(0L).allBitsIn(1L)) {
                entry = J9JITExceptionTablePointer.cast(bucket.at(0L));
            } else {
                bucket = PointerPointer.cast(bucket.at(0L));
                while (!(entry = J9JITExceptionTablePointer.cast(bucket.at(0L))).allBitsIn(1L)) {
                    if (searchValue.gte(entry.startPC()) && searchValue.lt(entry.endWarmPC())) {
                        return entry;
                    }
                    if (entry.startColdPC().longValue() != 0L && searchValue.gte(entry.startColdPC()) && searchValue.lt(entry.endPC())) {
                        return entry;
                    }
                    bucket = bucket.add(1L);
                }
            }
            entry = J9JITExceptionTablePointer.cast(UDATA.cast(entry).bitAnd(new UDATA(1L).bitNot()));
            if (searchValue.gte(entry.startPC()) && searchValue.lt(entry.endWarmPC())) {
                return entry;
            }
            if (entry.startColdPC().longValue() != 0L && searchValue.gte(entry.startColdPC()) && searchValue.lt(entry.endPC())) {
                return entry;
            }
        }
        return J9JITExceptionTablePointer.NULL;
    }

    private static class JITArtifactSearchCompare
    implements IAVLSearchComparator {
        private JITArtifactSearchCompare() {
        }

        @Override
        public int searchComparator(J9AVLTreePointer tree, UDATA searchValue, J9AVLTreeNodePointer node) throws CorruptDataException {
            J9JITHashTablePointer walkNode = J9JITHashTablePointer.cast(node);
            if (searchValue.gte(walkNode.end())) {
                return -1;
            }
            if (searchValue.lt(walkNode.start())) {
                return 1;
            }
            return 0;
        }
    }
}

