/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.command.CommandReader;
import com.ibm.j9ddr.command.ConsoleCommandReader;
import com.ibm.j9ddr.command.JNICommandReader;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.debugger.JniOutputStream;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.exceptions.JVMNotDDREnabledException;
import com.ibm.j9ddr.exceptions.JVMNotFoundException;
import com.ibm.j9ddr.exceptions.MissingDDRStructuresException;
import com.ibm.j9ddr.tools.ddrinteractive.ASNoProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ExtractMemoryCommand;
import com.ibm.j9ddr.tools.ddrinteractive.FindInMemoryCommand;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.J9XCommand;
import com.ibm.j9ddr.tools.ddrinteractive.MemoryRangesCommand;
import com.ibm.j9ddr.tools.ddrinteractive.MissingVMData;
import com.ibm.j9ddr.tools.ddrinteractive.commands.ForeachCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.LookupSymbolCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.NativeLibrariesCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.NativeStacksCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.TimeCommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginCommand;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImage;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDRInteractive
implements Runnable {
    private final PrintStream out;
    private final CommandReader commandReader;
    private static String path;
    private final List<Context> contexts = new LinkedList<Context>();
    private Context currentContext;
    private ICore currentCore;
    private final List<ICommand> nonVMCommands;

    public DDRInteractive(Object obj, PrintStream out) throws Exception {
        LinkedList<Command> localCommandList = new LinkedList<Command>();
        localCommandList.add(new J9XCommand());
        localCommandList.add(new ContextCommand());
        localCommandList.add(new MemoryRangesCommand());
        localCommandList.add(new FindInMemoryCommand());
        localCommandList.add(new J9HelpCommand());
        localCommandList.add(new PluginCommand());
        localCommandList.add(new NativeLibrariesCommand());
        localCommandList.add(new LookupSymbolCommand());
        localCommandList.add(new NativeStacksCommand());
        localCommandList.add(new ExtractMemoryCommand());
        localCommandList.add(new TimeCommand());
        localCommandList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(localCommandList);
        this.out = out;
        this.commandReader = new ConsoleCommandReader(out);
        path = null;
        if (obj instanceof J9DDRImage) {
            ICore icore = ((J9DDRImage)obj).getCore();
            this.locateRuntimes(icore);
            return;
        }
        if (obj instanceof IProcess) {
            this.addContextFromProcess((IProcess)obj);
            return;
        }
        if (obj instanceof ICore) {
            this.locateRuntimes((ICore)obj);
            return;
        }
        throw new IllegalArgumentException("The object parameter was not an instance of ICore, IProcess or J9DDRImage, it was " + obj.getClass().getName());
    }

    public DDRInteractive(IProcess proc, IVMData vmData, PrintStream out) throws Exception {
        LinkedList<Command> localCommandList = new LinkedList<Command>();
        localCommandList.add(new J9XCommand());
        localCommandList.add(new ContextCommand());
        localCommandList.add(new MemoryRangesCommand());
        localCommandList.add(new FindInMemoryCommand());
        localCommandList.add(new J9HelpCommand());
        localCommandList.add(new PluginCommand());
        localCommandList.add(new NativeLibrariesCommand());
        localCommandList.add(new LookupSymbolCommand());
        localCommandList.add(new NativeStacksCommand());
        localCommandList.add(new ExtractMemoryCommand());
        localCommandList.add(new TimeCommand());
        localCommandList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(localCommandList);
        this.out = out;
        this.commandReader = new ConsoleCommandReader(out);
        path = null;
        if (vmData != null) {
            this.contexts.add(new Context(proc, vmData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(proc);
        }
        this.currentContext = this.contexts.get(0);
    }

    public DDRInteractive(List<Object> dtfjcontexts, PrintStream out) throws Exception {
        LinkedList<Command> localCommandList = new LinkedList<Command>();
        localCommandList.add(new J9XCommand());
        localCommandList.add(new ContextCommand());
        localCommandList.add(new MemoryRangesCommand());
        localCommandList.add(new FindInMemoryCommand());
        localCommandList.add(new J9HelpCommand());
        localCommandList.add(new PluginCommand());
        localCommandList.add(new NativeLibrariesCommand());
        localCommandList.add(new LookupSymbolCommand());
        localCommandList.add(new NativeStacksCommand());
        localCommandList.add(new ExtractMemoryCommand());
        localCommandList.add(new TimeCommand());
        localCommandList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(localCommandList);
        this.out = out;
        this.commandReader = new ConsoleCommandReader(out);
        path = null;
        for (Object dtfjctx : dtfjcontexts) {
            if (!this.hasInterface(dtfjctx.getClass(), "com.ibm.java.diagnostics.utils.IDTFJContext")) continue;
            this.addDDRContextFromDTFJ(dtfjctx);
        }
        if (this.contexts.size() > 0) {
            this.currentContext = this.contexts.get(0);
        }
    }

    private boolean hasInterface(Class<?> clazz, String ifaceName) {
        Class<?>[] ifaces;
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            if (!iface.getName().equals(ifaceName)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return false;
        }
        return this.hasInterface(superclass, ifaceName);
    }

    private Method findMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() == null) {
                throw e;
            }
            return this.findMethod(clazz.getSuperclass(), name, parameterTypes);
        }
    }

    private void addDDRContextFromDTFJ(Object dtfjctx) throws Exception {
        Method getAddressSpace = this.findMethod(dtfjctx.getClass(), "getAddressSpace", null);
        Method getProcess = this.findMethod(dtfjctx.getClass(), "getProcess", null);
        Method getRuntime = this.findMethod(dtfjctx.getClass(), "getRuntime", null);
        Object addressSpace = getAddressSpace.invoke(dtfjctx, (Object[])null);
        Object process = getProcess.invoke(dtfjctx, (Object[])null);
        Object runtime = getRuntime.invoke(dtfjctx, (Object[])null);
        if (addressSpace == null) {
            throw new IOException("Cannot create a context without an associated address space");
        }
        if (!(addressSpace instanceof J9DDRImageAddressSpace)) {
            throw new UnsupportedOperationException("The supplied DTFJ context is not backed by a DDR implementation");
        }
        IAddressSpace space = ((J9DDRImageAddressSpace)addressSpace).getIAddressSpace();
        IProcess proc = null;
        if (process != null) {
            proc = ((J9DDRImageProcess)process).getIProcess();
        }
        if (proc == null) {
            ASNoProcess as = new ASNoProcess(space);
            this.addMissingJVMToContexts(as);
            return;
        }
        if (runtime == null) {
            this.addMissingJVMToContexts(proc);
            return;
        }
        IVMData vmData = VMDataFactory.getVMData(proc);
        if (vmData != null) {
            this.contexts.add(new Context(proc, vmData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(proc);
        }
    }

    private void addContextFromProcess(IProcess proc) throws IOException {
        IVMData vmData = VMDataFactory.getVMData(proc);
        if (vmData != null) {
            this.contexts.add(new Context(proc, vmData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(proc);
        }
    }

    public DDRInteractive(String path, PrintStream out) throws Exception {
        this(path, new ConsoleCommandReader(out), out);
    }

    public DDRInteractive(String path, CommandReader commandReader, PrintStream out) throws Exception {
        LinkedList<Command> localCommandList = new LinkedList<Command>();
        localCommandList.add(new J9XCommand());
        localCommandList.add(new ContextCommand());
        localCommandList.add(new MemoryRangesCommand());
        localCommandList.add(new FindInMemoryCommand());
        localCommandList.add(new J9HelpCommand());
        localCommandList.add(new PluginCommand());
        localCommandList.add(new NativeLibrariesCommand());
        localCommandList.add(new LookupSymbolCommand());
        localCommandList.add(new NativeStacksCommand());
        localCommandList.add(new ExtractMemoryCommand());
        localCommandList.add(new TimeCommand());
        localCommandList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(localCommandList);
        this.commandReader = commandReader;
        this.out = out;
        DDRInteractive.path = path;
        this.locateRuntimes(path);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            DDRInteractive app = new DDRInteractive(args[0], new PrintStream(System.out));
            app.startDDR();
        }
    }

    public static DDRInteractive instantiateDDR() {
        DDRInteractive app = null;
        JniOutputStream outputStream = new JniOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        JNICommandReader commandReader = new JNICommandReader(printStream);
        try {
            app = new DDRInteractive(null, commandReader, printStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger logger = Logger.getLogger("j9ddr.interactive.context");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logp(Level.FINE, null, null, sw.toString());
        }
        return app;
    }

    public Object[] getCommandNames() {
        Vector<String> commandNames = this.currentContext.getCommandNames();
        return commandNames.toArray();
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    public void startDDR() throws Exception {
        this.showContexts();
        this.out.print("Run !j9help to see a list of commands\n");
        this.commandReader.processInput(this);
    }

    public void setInputStream(InputStream in) {
        this.commandReader.setInputStream(in);
    }

    public void processLine(String line) throws Exception {
        this.commandReader.processLine(this, line);
    }

    public void showContexts() {
        try {
            this.commandReader.processLine(this, "!context");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public void run() {
        try {
            this.startDDR();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute(CommandParser command) {
        this.currentContext.execute(command, this.out);
    }

    public void execute(String command, String[] arguments) {
        this.currentContext.execute(command, arguments, this.out);
    }

    private void locateRuntimes(String path) throws Exception {
        ICore reader = CoreReader.readCoreFile(path);
        if (null == reader) {
            throw new RuntimeException("Cannot find Core Reader for file: " + path);
        }
        this.locateRuntimes(reader);
    }

    private void locateRuntimes(ICore reader) {
        this.currentCore = reader;
        Collection<? extends IAddressSpace> spaces = reader.getAddressSpaces();
        for (IAddressSpace iAddressSpace : spaces) {
            boolean hasCtxBeenAddedForAS = false;
            Collection<? extends IProcess> processes = iAddressSpace.getProcesses();
            for (IProcess iProcess : processes) {
                hasCtxBeenAddedForAS = true;
                try {
                    IVMData vmData = VMDataFactory.getVMData(iProcess);
                    if (vmData != null) {
                        this.contexts.add(new Context(iProcess, vmData, this.nonVMCommands));
                        continue;
                    }
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (JVMNotDDREnabledException e) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (JVMNotFoundException e) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (MissingDDRStructuresException e) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (IOException e) {
                    System.err.println("Problem searching for VMData in process " + iProcess);
                    e.printStackTrace();
                    Logger logger = Logger.getLogger("j9ddr.interactive.context");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    logger.logp(Level.FINE, null, null, sw.toString());
                }
            }
            if (hasCtxBeenAddedForAS) continue;
            ASNoProcess as = new ASNoProcess(iAddressSpace);
            this.addMissingJVMToContexts(as);
        }
        if (this.contexts.size() == 0) {
            throw new RuntimeException("Couldn't find any address spaces in this dump");
        }
        this.currentContext = this.contexts.get(0);
        for (Context context : this.contexts) {
            if (context.vmData instanceof MissingVMData) continue;
            this.currentContext = context;
            break;
        }
    }

    private void addMissingJVMToContexts(IProcess thisProcess) {
        MissingVMData novm = new MissingVMData();
        Context ctx = new Context(thisProcess, novm, this.nonVMCommands);
        this.contexts.add(ctx);
    }

    public Collection getStructuresForCurrentContext() {
        return this.currentContext.vmData.getStructures();
    }

    public static String getPath() {
        return System.getProperty("com.ibm.j9ddr.tools.ddrinteractive.filepath", path);
    }

    public void close() throws Exception {
        if (this.currentCore != null) {
            this.currentCore.close();
        }
        VMDataFactory.clearCache();
    }

    public class ContextCommand
    extends Command {
        public ContextCommand() {
            this.addCommand("context", "[ctx#]", "Lists or selects context (VM) to work with");
        }

        @Override
        public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
            if (args.length == 0) {
                this.printContextList(false);
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("short")) {
                    this.printContextList(true);
                } else {
                    this.switchContext(args);
                }
            } else {
                throw new DDRInteractiveCommandException("Unexpected arguments. Usage: !context to list contexts, !context <id> to select a context.");
            }
        }

        private void switchContext(String[] args) throws DDRInteractiveCommandException {
            try {
                int index = Integer.parseInt(args[0]);
                if (index < 0 || index >= DDRInteractive.this.contexts.size()) {
                    throw new DDRInteractiveCommandException("Context ID out of range. Range should be between 0 and " + (DDRInteractive.this.contexts.size() - 1) + " inclusive");
                }
                DDRInteractive.this.currentContext = (Context)DDRInteractive.this.contexts.get(index);
                DDRInteractive.this.out.println("Switched to " + DDRInteractive.this.currentContext);
            }
            catch (NumberFormatException ex) {
                throw new DDRInteractiveCommandException("Couldn't parse context ID", ex);
            }
        }

        private void printContextList(boolean shortFormat) {
            int count = 0;
            for (Context thisContext : DDRInteractive.this.contexts) {
                if (thisContext == DDRInteractive.this.currentContext) {
                    DDRInteractive.this.out.print("*");
                } else {
                    DDRInteractive.this.out.print(" ");
                }
                DDRInteractive.this.out.print(count);
                DDRInteractive.this.out.print(" : ");
                DDRInteractive.this.out.println(thisContext.toString(shortFormat));
                ++count;
            }
        }
    }

    public class J9HelpCommand
    extends Command {
        public J9HelpCommand() {
            this.addCommand("j9help", "", "Prints the help table");
            this.addCommand("exit", "", "Exits from DDR Interactive");
            this.addCommand("quit", "", "Quits DDR Interactive: a synonym for \"exit\"");
        }

        @Override
        public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
            TreeSet<String> helpTable = new TreeSet<String>();
            for (ICommand thisCommand : DDRInteractive.this.nonVMCommands) {
                for (String thisEntry : thisCommand.getCommandDescriptions()) {
                    if (!thisEntry.endsWith("\n")) {
                        thisEntry = thisEntry + "\n";
                    }
                    helpTable.add(thisEntry);
                }
            }
            for (ICommand thisCommand : context.commands) {
                for (String thisEntry : thisCommand.getCommandDescriptions()) {
                    if (!thisEntry.endsWith("\n")) {
                        thisEntry = thisEntry + "\n";
                    }
                    helpTable.add(thisEntry);
                }
            }
            for (String entry : helpTable) {
                out.print(entry);
            }
        }
    }
}

