/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ant;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class ExecOverFiles
extends Task {
    private List<FileSet> fileSets = new LinkedList<FileSet>();
    private final ExecTask exec = new ExecTask();
    private String command = null;
    private final String FILENAME_REPLACE = "$FILENAME";

    public void addFileset(FileSet fileset) {
        this.fileSets.add(fileset);
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public void execute() throws BuildException {
        if (this.exec == null) {
            throw new BuildException("No <exec> nested element supplied.");
        }
        if (this.command == null || this.command.length() == 0) {
            throw new BuildException("No non-empty command attribute supplied.");
        }
        for (FileSet fs : this.fileSets) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            this.exec.setDir(scanner.getBasedir());
            for (String filename : files) {
                Commandline cmd = new Commandline(this.command.replace("$FILENAME", filename));
                this.exec.setCommand(cmd);
                this.exec.setOutput(new File(scanner.getBasedir() + "/" + filename));
                this.exec.execute();
            }
        }
    }
}

