/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.mvs;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.BpxzotcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.BpxzustaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.CeexcvtTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaascbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaasxbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhapsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IharbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhastcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhawebTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaxsbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjrbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjrbprefixTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjtcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lse;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsedTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lsestate1Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsestateTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.OtcbcopyonforkTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tcb {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private Lse[] linkageStack;
    private static final int RBFTPRB = 0;
    private static final int FastPathPCLow = 4871;
    private static final int OmvsPcLow = 4864;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private boolean assertionsEnabled = false;
    private int release = 0;

    public static Tcb[] getTcbs(AddressSpace space) {
        ProgressMeter.set("getting tcbs", 50);
        AddressSpaceImageInputStream inputStream = space.getImageInputStream();
        AddressSpaceImageInputStream rootInputStream = space.getRootAddressSpace().getImageInputStream();
        Tcb[] tcbs = (Tcb[])space.getUserMap().get("tcbmap");
        if (tcbs != null) {
            return tcbs;
        }
        log.fine("creating Tcb array for asid " + space);
        Vector<Tcb> v = new Vector<Tcb>();
        try {
            long asxbltcb;
            long psaaold = IhapsaTemplate.getPsaaold(rootInputStream, 0L);
            if (psaaold == 0L) {
                log.fine("psaaold is zero so no tcbs in asid " + space);
                return null;
            }
            long ascbasxb = IhaascbTemplate.getAscbasxb(rootInputStream, psaaold);
            long asxbftcb = IhaasxbTemplate.getAsxbftcb(inputStream, ascbasxb);
            if (asxbftcb == (asxbltcb = IhaasxbTemplate.getAsxbltcb(inputStream, ascbasxb))) {
                log.fine("first and last tcb pointers are equal so no tcbs in asid " + space);
                return null;
            }
            Tcb tcb = new Tcb(space, asxbftcb);
            while (true) {
                ProgressMeter.set("getting tcb " + Tcb.hex(tcb.address()), 50);
                v.add(tcb);
                if (tcb.address() != asxbltcb && tcb.tcbtcb() != 0L) {
                    tcb = new Tcb(space, tcb.tcbtcb());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.logp(Level.FINE, "com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb", "getTcbs", "Caught Exception", e);
            return null;
        }
        tcbs = v.toArray(new Tcb[0]);
        space.getUserMap().put("tcbmap", tcbs);
        ProgressMeter.set("finished getting tcbs", 50);
        return tcbs;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb(AddressSpace space, long address) {
        log.fine("creating Tcb at address " + Tcb.hex(address));
        this.space = space;
        this.address = address;
        this.inputStream = space.getImageInputStream();
        String s = space.getDump().getProductRelease();
        if (s != null) {
            this.release = new Integer(s);
        }
    }

    public long tcbcelap() throws IOException {
        return IkjtcbTemplate.getTcbcelap(this.inputStream, this.address);
    }

    public long tcbrtwa() throws IOException {
        return IkjtcbTemplate.getTcbrtwa(this.inputStream, this.address);
    }

    public long tcbcmp() throws IOException {
        return IkjtcbTemplate.getTcbcmp(this.inputStream, this.address) & 0xFFFFFFFFL;
    }

    public long tcbrbp() throws IOException {
        return IkjtcbTemplate.getTcbrbp(this.inputStream, this.address);
    }

    public long tcbstcb() throws IOException {
        return IkjtcbTemplate.getTcbstcb(this.inputStream, this.address);
    }

    public long tcbtcb() throws IOException {
        return IkjtcbTemplate.getTcbtcb(this.inputStream, this.address);
    }

    public long tcbotcb() throws IOException {
        return IhastcbTemplate.getStcbotcb(this.inputStream, this.tcbstcb());
    }

    public long tcbthli() throws IOException {
        return BpxzotcbTemplate.getOtcbthli(this.inputStream, this.tcbotcb());
    }

    public RegisterSet getRegisters() throws IOException {
        log.fine("getRegisters");
        RegisterSet regs = new RegisterSet();
        try {
            long tcbgrs = this.address + (long)IkjtcbTemplate.getTcbgrs$offset();
            for (int i = 0; i < 16; ++i) {
                regs.setRegister(i, this.space.readUnsignedInt(tcbgrs + (long)(i * 4)));
            }
            regs.setPSW(IharbTemplate.getRbopsw(this.inputStream, this.tcbrbp()));
            if (this.space.is64bit()) {
                long stcbg64h = this.tcbstcb() + (long)IhastcbTemplate.getStcbg64h$offset();
                for (int i = 0; i < 16; ++i) {
                    long high = this.space.readUnsignedInt(stcbg64h + (long)(i * 4));
                    regs.setRegister(i, regs.getRegister(i) | high << 32);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error("oops: " + e);
        }
        return regs;
    }

    public RegisterSet getRegistersFromBPXGMSTA() throws IOException {
        RegisterSet regs;
        block20: {
            regs = new RegisterSet();
            try {
                long rbp = this.tcbrbp();
                long rbsecptr = 0L;
                long save2rbptr = 0L;
                long save2XsbPtr = 0L;
                long saveXsbAddr = 0L;
                log.fine("for tcb " + Tcb.hex(this.address) + ", rbp = " + Tcb.hex(rbp));
                int countRbs = 0;
                do {
                    log.fine("currently looking at rbp 0x" + Tcb.hex(rbp));
                    save2rbptr = rbsecptr;
                    save2XsbPtr = saveXsbAddr;
                    saveXsbAddr = IkjrbprefixTemplate.getRbxsb(this.inputStream, rbp - 64L);
                    rbsecptr = rbp;
                    rbp = IharbTemplate.getRblinkXrblnkRblinkb(this.inputStream, rbp);
                    ++countRbs;
                } while (rbp != this.address);
                log.fine("found " + countRbs + " rbs");
                if (countRbs == 1) {
                    this.getLinkageStack();
                    if (this.linkageStack.length == 0) {
                        log.fine("empty linkage stack, get registers from TCB");
                        regs = this.getRegisters();
                        regs.setWhereFound("BPXGMSTA/TCB");
                        break block20;
                    }
                    log.fine("linkageStack.length = " + this.linkageStack.length);
                    long stcbotcb = this.tcbotcb();
                    boolean otcbptregsinusta = false;
                    if (stcbotcb != 0L) {
                        boolean bl = otcbptregsinusta = BpxzotcbTemplate.getOtcbptregsinusta(this.inputStream, stcbotcb) != 0L;
                    }
                    if (otcbptregsinusta && stcbotcb != 0L) {
                        long otcbcofptr = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, stcbotcb);
                        throw new Error("tbc");
                    }
                    log.fine("try first linkage stack entry");
                    Lse lse = this.linkageStack[this.linkageStack.length - 1];
                    assert (stcbotcb != 0L);
                    long otcbcofptr = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, stcbotcb);
                    long otcbustaptr = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, otcbcofptr);
                    log.fine("lse type " + lse.lses1typ7());
                    if ((lse.lsestyp7() == 5 || lse.lses1typ7() == 13) && lse.lsestarg() < 4871L && lse.lsestarg() >= 4864L && otcbustaptr != 0L) {
                        regs = null;
                        break block20;
                    }
                    log.fine("try last linkage stack entry");
                    lse = this.linkageStack[0];
                    if (lse.lses1typ7() == 13 || lse.lses1typ7() == 12) {
                        regs.setPSW(lse.lses1pswh());
                        for (int i = 0; i < 16; ++i) {
                            regs.setRegister(i, lse.lses1grs(i));
                        }
                    } else {
                        regs.setPSW(lse.lsespsw());
                        for (int i = 0; i < 16; ++i) {
                            regs.setRegister(i, lse.lsesgrs(i));
                        }
                    }
                    regs.setWhereFound("BPXGMSTA/Linkage");
                    break block20;
                }
                long rbftp = IkjrbTemplate.getRbftp(this.inputStream, rbsecptr);
                if (rbftp == 0L) {
                    log.fine("BPXGMSTA/RBFTPRB");
                    regs.setPSW(IharbTemplate.getRbopsw(this.inputStream, rbsecptr));
                    long rbgrsave_offset = IharbTemplate.getRbgrsave$offset();
                    long xsbg64h_offset = IhaxsbTemplate.getXsbg64h$offset();
                    if (this.space.is64bit() || this.release >= 12) {
                        for (int i = 0; i < 16; ++i) {
                            long low = this.space.readUnsignedInt(save2rbptr + rbgrsave_offset + (long)(i * 4));
                            long high = this.space.readUnsignedInt(save2XsbPtr + xsbg64h_offset + (long)(i * 4));
                            regs.setRegister(i, high << 32 | low);
                        }
                    } else {
                        for (int i = 0; i < 16; ++i) {
                            long low = this.space.readUnsignedInt(save2rbptr + rbgrsave_offset + (long)(i * 4));
                            regs.setRegister(i, low);
                        }
                    }
                    regs.setWhereFound("BPXGMSTA/RBFTPRB");
                    break block20;
                }
                throw new Error("tbc");
            }
            catch (IOException e) {
                if (!$assertionsDisabled) {
                    this.assertionsEnabled = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                log.logp(Level.FINE, "com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb", "getRegistersFromBPXGMSTA", "Caught and rethrew exception", e);
                throw e;
            }
        }
        return regs;
    }

    public RegisterSet getRegistersFromUsta() throws IOException {
        RegisterSet regs = new RegisterSet();
        long stcbotcb = this.tcbotcb();
        long otcbcofptr = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, stcbotcb);
        long otcbustaptr = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, otcbcofptr);
        long ustagrs = otcbustaptr + (long)BpxzustaTemplate.getUstagrs$offset();
        long cvt = IhapsaTemplate.getFlccvt(this.inputStream, 0L);
        long cvtoslv3 = CeexcvtTemplate.getCvtoslv3(this.inputStream, cvt);
        if ((cvtoslv3 & 2L) != 0L) {
            log.fine("new level of OS (0x" + Tcb.hex(cvtoslv3) + ")");
        } else {
            log.fine("old level of OS (0x" + Tcb.hex(cvtoslv3) + ") so adjust usta pointer");
            ustagrs -= 8L;
        }
        for (int i = 0; i < 16; ++i) {
            regs.setRegister(i, this.space.readUnsignedInt(ustagrs + (long)(i * 4)));
        }
        long ustapsw = otcbustaptr + (long)BpxzustaTemplate.getUstapswg$offset();
        regs.setPSW(this.space.readLong(ustapsw));
        regs.setWhereFound("BPXGMSTA/USTA");
        return regs;
    }

    public Lse[] getLinkageStack() throws IOException {
        if (this.linkageStack != null) {
            return this.linkageStack;
        }
        try {
            long stcb = this.tcbstcb();
            long stcbestk = IhastcbTemplate.getStcbestk(this.inputStream, stcb);
            long stcblsdp = IhastcbTemplate.getStcblsdp(this.inputStream, stcb);
            if (stcbestk == stcblsdp) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            long entrysize = LsedTemplate.getLsednes(this.inputStream, stcbestk);
            if (entrysize <= 0L) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            assert (entrysize == (long)LsestateTemplate.length() || entrysize == (long)Lsestate1Template.length()) : entrysize;
            assert ((stcblsdp - stcbestk) % entrysize == 0L) : (stcblsdp - stcbestk) % entrysize;
            int numEntries = (int)((stcblsdp - stcbestk) / entrysize);
            assert (numEntries >= 0 && numEntries < 100) : numEntries;
            this.linkageStack = new Lse[numEntries];
            long lsedptr = stcblsdp - entrysize;
            for (int i = 0; i < numEntries; ++i) {
                this.linkageStack[i] = new Lse(this.space, lsedptr);
                lsedptr -= entrysize;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error("oops: " + e);
        }
        return this.linkageStack;
    }

    public boolean isIFAEnabled() throws IOException {
        byte ifaFlags = this.getIFAFlags();
        return (ifaFlags & 0x80) == 128 || (ifaFlags & 0x10) == 16;
    }

    public byte getIFAFlags() throws IOException {
        long stcbAddress = this.tcbstcb();
        long webAddress = IhastcbTemplate.getStcbweb(this.inputStream, stcbAddress);
        return IhawebTemplate.getWebflag2(this.inputStream, webAddress);
    }

    public boolean equals(Object obj) {
        Tcb tcb = (Tcb)obj;
        return tcb.space == this.space && tcb.address == this.address;
    }

    public int hashCode() {
        return (int)this.address;
    }

    private static String hex(long n) {
        return Long.toHexString(n);
    }
}

