/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.mvs;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsedTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lses1lsed1Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LseslsedTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lsestate1Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsestateTemplate;
import java.io.IOException;

public class Lse {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private long lsesptr;
    public static final int LSEDPC = 5;
    public static final int LSED1PC = 13;
    public static final int LSED1BAKR = 12;

    public Lse(AddressSpace space, long address) {
        this.space = space;
        this.inputStream = space.getImageInputStream();
        this.address = address;
        this.lsesptr = address + (long)LseslsedTemplate.length();
    }

    public long address() {
        return this.address;
    }

    public int lsestyp7() throws IOException {
        return (int)LseslsedTemplate.getLsestyp7(this.inputStream, this.lsesptr + (long)LsestateTemplate.getLses_ed$offset());
    }

    public int lses1typ7() throws IOException {
        return (int)Lses1lsed1Template.getLses1typ7(this.inputStream, this.lsesptr + (long)Lsestate1Template.getLses1_ed1$offset());
    }

    public long lsestarg() throws IOException {
        return LsestateTemplate.getLsestarg(this.inputStream, this.lsesptr);
    }

    public long lsespsw() throws IOException {
        return LsestateTemplate.getLsespsw(this.inputStream, this.lsesptr);
    }

    public long lses1pswh() throws IOException {
        return Lsestate1Template.getLses1pswh(this.inputStream, this.lsesptr);
    }

    public long lsesgrs(int gpr) throws IOException {
        if (gpr < 0 || gpr > 15) {
            throw new IndexOutOfBoundsException("gpr out of range 0-15: " + gpr);
        }
        return this.space.readLong(this.lsesptr + (long)LsestateTemplate.getLsesgrs$offset() + (long)(gpr * 4));
    }

    public long lses1grs(int gpr) throws IOException {
        if (gpr < 0 || gpr > 15) {
            throw new IndexOutOfBoundsException("gpr out of range 0-15: " + gpr);
        }
        return this.space.readLong(this.lsesptr + (long)Lsestate1Template.getLses1grs$offset() + (long)(gpr * 8));
    }

    public int lses1pasn() throws IOException {
        return (int)Lsestate1Template.getLses1pasn(this.inputStream, this.lsesptr);
    }

    public boolean isZArchitecture() throws IOException {
        long entrysize = LsedTemplate.getLsednes(this.inputStream, this.address);
        return entrysize == (long)Lsestate1Template.length();
    }

    private static String hex(long n) {
        return Long.toHexString(n);
    }
}

