/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.MutableAddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllFunction;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Emulator;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionEmulator {
    private AddressSpace space;
    private Emulator em;
    private long functionEntryPoint;
    private BitSet ignoreFunctionTrace = new BitSet();
    private MutableAddressSpace mspace;
    private int[] args = new int[3];
    private long returnValue;
    private long stackBase;
    private boolean printOffsets;
    private Function callTreeRoot;
    private Function currentFunction;
    private boolean recordTrace;
    private ArrayList traceEntries;
    private HashMap replacedFunctions = new HashMap();
    private ObjectMap enteredFunctions = new ObjectMap();
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public FunctionEmulator(AddressSpace space, String functionName) throws IOException, NoSuchMethodException {
        DllFunction function = Dll.getFunction(space, functionName);
        if (function == null) {
            throw new NoSuchMethodException("cannot find function: " + functionName);
        }
        log.fine("creating emulator for function " + functionName + " address " + FunctionEmulator.hex(function.address) + " env " + FunctionEmulator.hex(function.env));
        this.createEmulator(space, function.address, function.env);
        if (((space.readInt(function.address) & 0xFF00F000) != -1879031808 || (space.readInt(function.address + 4L) & Short.MIN_VALUE) != -1488289792) && (space.readInt(function.address) & 0xFFFFF000) == 1206972416) {
            this.em.setRegister(15, (int)function.address);
            this.em.setRegister(13, this.stackBase + 4096L);
            assert (!space.is64bit());
            this.mspace.writeInt(this.em.getRegister(13) + 76L, (int)this.stackBase + 8192);
            this.em.setRegister(4, -559038737);
            this.em.setRegister(14, this.em.getRegister(7));
            this.em.setRegister(7, -559038737);
        }
    }

    public FunctionEmulator(AddressSpace space, long functionEntryPoint, long functionEnv) throws IOException, NoSuchMethodException {
        this.createEmulator(space, functionEntryPoint, functionEnv);
    }

    void createEmulator(AddressSpace space, long functionEntryPoint, long functionEnv) throws IOException {
        this.functionEntryPoint = functionEntryPoint;
        this.space = space;
        try {
            this.em = (Emulator)Class.forName("com.ibm.zebedee.emulator.EmulatorImpl").newInstance();
        }
        catch (Exception e) {
            throw new Error("unable to instantiate com.ibm.zebedee.emulator.EmulatorImpl");
        }
        this.mspace = new MutableAddressSpace(space);
        int r4len = 65536;
        this.stackBase = this.mspace.malloc(r4len);
        this.em.setRegister(4, this.stackBase + (long)r4len - 4096L);
        this.em.setRegister(5, functionEnv);
        this.em.setRegister(6, functionEntryPoint);
        this.createDummyReturnAddress();
    }

    public long getStackFloor() {
        return this.stackBase;
    }

    public long createDummyReturnAddress() throws IOException {
        long returnAddress = this.mspace.rmalloc(1);
        this.em.setRegister(7, returnAddress);
        Emulator.CallbackFunction returnCallback = new Emulator.CallbackFunction(){

            @Override
            public boolean call(Emulator em) {
                em.stop();
                FunctionEmulator.this.returnValue = em.getRegister(3);
                return false;
            }
        };
        this.em.registerCallbackFunction(returnAddress, returnCallback);
        this.em.registerCallbackFunction(returnAddress + 2L, returnCallback);
        this.em.registerCallbackFunction(returnAddress + 4L, returnCallback);
        return returnAddress;
    }

    public void setPrintOffsets(boolean printOffsets) {
        this.printOffsets = printOffsets;
    }

    public void setInstructionTracing(boolean instructionTrace) {
        this.em.setTraceListener(instructionTrace ? new TraceListener() : null);
    }

    public void setInstructionRecording(boolean instructionRecord) {
        this.em.setTraceListener(instructionRecord ? new TraceListener() : null);
        if (instructionRecord) {
            this.recordTrace = true;
            this.traceEntries = new ArrayList();
        } else {
            this.recordTrace = false;
        }
    }

    public List getTraceEntries() {
        return this.traceEntries;
    }

    public void setBranchInstructionTracing(boolean branchInstructionTrace) {
        this.em.setBranchTraceListener(branchInstructionTrace ? new BranchTraceListener() : null);
    }

    public void setCallTreeCapture() {
        this.currentFunction = this.callTreeRoot = new Function("root", null);
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String name, long targetAddress) {
                FunctionEmulator.this.currentFunction = FunctionEmulator.this.currentFunction.addChild(name);
            }

            @Override
            protected void exitFunction(String name) {
                FunctionEmulator.this.currentFunction = FunctionEmulator.this.currentFunction.getParent();
                if (FunctionEmulator.this.currentFunction == null) {
                    assert (false) : "shouldn't happen in theory";
                    FunctionEmulator.this.currentFunction = FunctionEmulator.this.callTreeRoot;
                }
            }
        });
    }

    public Function getCallTreeRoot() {
        return this.callTreeRoot;
    }

    public Function getCurrentFunction() {
        return this.currentFunction;
    }

    public Emulator getEmulator() {
        return this.em;
    }

    public void setArgument(int argNumber, int value) {
        if (argNumber < 4) {
            this.em.setRegister(argNumber, value);
        } else {
            try {
                this.mspace.writeInt(this.em.getRegister(4) + 2112L + (long)(argNumber - 1 << 2), value);
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
        }
    }

    public void setArgument(int argNumber, long value) {
        if (argNumber < 4) {
            this.em.setRegister(argNumber, value);
        } else {
            try {
                if (this.mspace.is64bit()) {
                    this.mspace.writeLong(this.em.getRegister(4) + 2176L + (long)(argNumber - 1 << 3), value);
                } else {
                    this.mspace.writeInt(this.em.getRegister(4) + 2112L + (long)(argNumber - 1 << 2), (int)value);
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
        }
    }

    public long getArgument(int argNumber) {
        if (argNumber < 4) {
            return this.em.getRegister(argNumber);
        }
        try {
            if (this.mspace.is64bit()) {
                return this.mspace.readLong(this.em.getRegister(4) + 2176L + (long)(argNumber - 1 << 3));
            }
            return this.mspace.readInt(this.em.getRegister(4) + 2112L + (long)(argNumber - 1 << 2));
        }
        catch (IOException e) {
            throw new Error("oops: " + e);
        }
    }

    public MutableAddressSpace getMutableAddressSpace() {
        return this.mspace;
    }

    public long registerCallbackFunction(final CallbackFunction callback) {
        try {
            long ep = this.mspace.malloc(1);
            long linkage = this.mspace.malloc(32);
            if (this.mspace.is64bit()) {
                this.mspace.writeLong(linkage + 8L, ep);
            } else {
                this.mspace.writeInt(linkage + 20L, (int)ep);
            }
            this.em.registerCallbackFunction(ep, new Emulator.CallbackFunction(){

                @Override
                public boolean call(Emulator em) throws IOException {
                    try {
                        long ret = callback.call(FunctionEmulator.this);
                        em.setRegister(3, ret);
                        return false;
                    }
                    catch (CallOriginalException e) {
                        assert (false);
                        return true;
                    }
                }
            });
            this.ignoreFunctionTrace.set((int)ep & Integer.MAX_VALUE);
            return linkage;
        }
        catch (IOException e) {
            throw new Error("oops: " + e);
        }
    }

    public void overrideFunction(String functionName, CallbackFunction callback) throws IOException, NoSuchMethodException {
        DllFunction function = Dll.getFunction(this.space, functionName);
        if (function == null) {
            throw new NoSuchMethodException("cannot find function: " + functionName);
        }
        this.overrideFunction(function.address, callback);
    }

    public void overrideFunction(long functionEntryPoint, final CallbackFunction callback) throws IOException, NoSuchMethodException {
        this.em.registerCallbackFunction(functionEntryPoint, new Emulator.CallbackFunction(){

            @Override
            public boolean call(Emulator em) throws IOException {
                try {
                    long ret = callback.call(FunctionEmulator.this);
                    em.setRegister(3, ret);
                    return false;
                }
                catch (CallOriginalException e) {
                    return true;
                }
            }
        });
    }

    public void overrideFunction(String functionName, long retVal, boolean protect) {
        this.replacedFunctions.put(functionName, new Replace(retVal, protect));
        this.em.setFunctionReplacer(new Emulator.FunctionReplacer(){

            @Override
            public boolean replace(Emulator em, long targetAddress) throws IOException {
                Replace ret;
                String functionName = (String)FunctionEmulator.this.enteredFunctions.get(targetAddress);
                if (functionName == null) {
                    functionName = DsaStackFrame.getEntryPointName(FunctionEmulator.this.space, FunctionEmulator.this.stripTopBit(targetAddress));
                    FunctionEmulator.this.enteredFunctions.put(targetAddress, functionName);
                }
                if ((ret = (Replace)FunctionEmulator.this.replacedFunctions.get(functionName)) != null) {
                    if (ret.protect) {
                        try {
                            em.saveState();
                            long returnAddress = FunctionEmulator.this.createDummyReturnAddress();
                            em.setRegister(7, returnAddress);
                            em.run(FunctionEmulator.this.mspace, targetAddress);
                            long r = em.getRegister(3);
                            em.restoreState();
                            em.setRegister(3, r);
                        }
                        catch (IOException e) {
                            log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.FunctionEmulator.overrideFunction(...).FunctionReplacer", "replace", "Unexpected Exception", e);
                            em.restoreState();
                            em.setRegister(3, ret.retVal);
                        }
                        em.resume();
                        return true;
                    }
                    em.setRegister(3, ret.retVal);
                    return true;
                }
                return false;
            }
        });
    }

    public void overrideFunction(String functionName, long returnValue) {
        this.overrideFunction(functionName, returnValue, false);
    }

    private long stripTopBit(long address) {
        return this.mspace.is64bit() ? address : address & Integer.MAX_VALUE;
    }

    public long run() throws IOException {
        this.em.run(this.mspace, this.functionEntryPoint);
        return this.returnValue;
    }

    public long run(long functionPointer) throws IOException {
        long env;
        long ep;
        if (this.mspace.is64bit()) {
            ep = this.mspace.readLong(functionPointer + 8L);
            env = this.mspace.readLong(functionPointer + 0L);
        } else {
            ep = this.mspace.readInt(functionPointer + 20L);
            env = this.mspace.readInt(functionPointer + 16L);
        }
        this.em.setRegister(5, env);
        long returnAddress = this.createDummyReturnAddress();
        this.em.setRegister(7, returnAddress);
        long oldEp = this.functionEntryPoint;
        this.functionEntryPoint = ep;
        this.em.run(this.mspace, this.functionEntryPoint);
        this.functionEntryPoint = oldEp;
        this.mspace.free(returnAddress);
        return this.returnValue;
    }

    private void setEnvReg(long address) {
        this.em.setRegister(5, address);
        try {
            long ptr = this.mspace.readInt(address);
            ptr &= 0xFFFFFFFFFFFFF000L;
            int i = 0;
            while (i < 3) {
                try {
                    this.mspace.readInt(ptr);
                }
                catch (IOException ee) {
                    this.mspace.allocPage(ptr);
                    log.fine("Filled in hole at " + FunctionEmulator.hex(ptr));
                }
                ++i;
                ptr += 4096L;
            }
        }
        catch (IOException e) {
            log.fine("Cannot read env: " + FunctionEmulator.hex(address));
        }
    }

    public long run(String functionName) throws IOException, NoSuchMethodException {
        DllFunction function = Dll.getFunction(this.space, functionName);
        if (function == null) {
            throw new NoSuchMethodException("cannot find function: " + functionName);
        }
        this.setEnvReg(function.env);
        this.createDummyReturnAddress();
        this.em.run(this.mspace, function.address);
        return this.returnValue;
    }

    public void recordCalledFunctions() throws IOException {
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String name, long targetAddress) {
                long r5 = FunctionEmulator.this.getEmulator().getRegister(5);
                DllFunction function = new DllFunction(name, targetAddress, null, r5);
                Dll.addFunction(FunctionEmulator.this.space, name, function);
                log.fine("Adding " + name);
            }

            @Override
            protected void exitFunction(String name) {
            }
        });
        this.runAllPaths();
    }

    public void recordAllCalledFunctions() throws IOException {
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String name, long targetAddress) {
                long r5 = FunctionEmulator.this.getEmulator().getRegister(5);
                DllFunction function = new DllFunction(name, targetAddress, null, r5);
                Dll.addFunction(FunctionEmulator.this.space, name, function);
                log.fine("Adding " + name);
            }

            @Override
            protected void exitFunction(String name) {
            }
        });
        this.run();
    }

    public void runAllPaths() throws IOException {
        this.em.runAllPaths(this.mspace, this.functionEntryPoint);
    }

    static String hex(long i) {
        return Long.toHexString(i);
    }

    static String hexpad(long i) {
        String s = FunctionEmulator.hex(i);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    static String hex(int i) {
        return Integer.toHexString(i);
    }

    static String hexpad(int i) {
        String s = FunctionEmulator.hex(i);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    private class BranchTraceListener
    implements Emulator.BranchTraceListener {
        ObjectMap map = new ObjectMap();
        long lastTargetAddress;
        long lastReturnAddress;
        int indent;

        private BranchTraceListener() {
        }

        protected void enterFunction(String name, long targetAddress) {
            System.out.println("[" + this.indent + "] enter " + name);
            ++this.indent;
        }

        protected void exitFunction(String name) {
            --this.indent;
            System.out.println("[" + this.indent + "] exit " + name);
        }

        @Override
        public void traceBranchAndSave(Emulator em, Emulator.Instruction inst, long returnAddress, long targetAddress) throws IOException {
            this.doTraceBranchAndSave(em, inst, returnAddress, targetAddress);
        }

        void doTraceBranchAndSave(Emulator em, Emulator.Instruction inst, long returnAddress, long targetAddress) throws IOException {
            returnAddress &= Integer.MAX_VALUE;
            if ((targetAddress &= Integer.MAX_VALUE) == this.lastReturnAddress) {
                this.doTraceBranchOnCondition(em, inst, true, targetAddress);
                this.lastReturnAddress = 0L;
            } else if (!FunctionEmulator.this.ignoreFunctionTrace.get((int)targetAddress)) {
                Emulator.BranchRelative brinst;
                String functionName = DsaStackFrame.getEntryPointName(FunctionEmulator.this.space, targetAddress);
                if (inst.id() == 2677 && (brinst = (Emulator.BranchRelative)((Object)inst)).getOffset() > 0L && brinst.getOffset() < 32L && functionName.equals("(unknown)")) {
                    return;
                }
                this.map.put(returnAddress, functionName);
                this.enterFunction(functionName, targetAddress);
            }
            this.lastReturnAddress = returnAddress;
            this.lastTargetAddress = 0L;
        }

        @Override
        public void traceBranchOnCondition(Emulator em, Emulator.Instruction inst, boolean branched, long targetAddress) throws IOException {
            this.doTraceBranchOnCondition(em, inst, branched, targetAddress);
        }

        void doTraceBranchOnCondition(Emulator em, Emulator.Instruction inst, boolean branched, long targetAddress) throws IOException {
            if (inst.id() == 2676) {
                return;
            }
            String functionName = (String)this.map.get((targetAddress &= Integer.MAX_VALUE) - 4L);
            if (functionName == null) {
                functionName = (String)this.map.get(targetAddress);
            }
            if (functionName == null) {
                functionName = (String)this.map.get(targetAddress - 2L);
            }
            if (functionName != null && targetAddress != this.lastTargetAddress + 4L) {
                this.exitFunction(functionName);
            }
            this.lastTargetAddress = targetAddress;
        }
    }

    private class TraceListener
    extends BranchTraceListener
    implements Emulator.TraceListener {
        TraceEntry entry;

        private TraceListener() {
        }

        public void trace(Emulator.Instruction inst) throws IOException {
            this.entry = new TraceEntry(inst.address(), inst.address() - FunctionEmulator.this.functionEntryPoint, inst.toString());
        }

        void recordOrPrint(TraceEntry entry) {
            if (FunctionEmulator.this.recordTrace) {
                FunctionEmulator.this.traceEntries.add(entry);
            } else {
                log.fine(entry.toString());
            }
        }

        @Override
        protected void enterFunction(String name, long targetAddress) {
            if (!name.equals("(unknown)")) {
                this.entry.result = this.entry.result + " (enter " + name + ")";
            }
        }

        @Override
        protected void exitFunction(String name) {
            if (!name.equals("(unknown)")) {
                this.entry.result = this.entry.result + " (exit " + name + ")";
            }
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst) throws IOException {
            this.trace(inst);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, int[] result) throws IOException {
            this.trace(inst);
            for (int i = 0; i < result.length; ++i) {
                this.entry.result = this.entry.result + FunctionEmulator.hexpad(result[i]) + " ";
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, long[] result) throws IOException {
            this.trace(inst);
            for (int i = 0; i < result.length; ++i) {
                this.entry.result = this.entry.result + FunctionEmulator.hexpad(result[i]) + " ";
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, String result) throws IOException {
            this.trace(inst);
            this.entry.result = result;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, int result) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(result);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, double result) throws IOException {
            this.trace(inst);
            this.entry.result = "" + result;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, int arg1, int arg2) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(arg1) + " " + FunctionEmulator.hexpad(arg2);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, double arg1, double arg2) throws IOException {
            this.trace(inst);
            this.entry.result = "" + arg1 + " " + arg2;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, long result) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(result);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, long arg1, long arg2) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(arg1) + " " + FunctionEmulator.hexpad(arg2);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, int result, long address) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(result) + " " + FunctionEmulator.hexpad(address);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator em, Emulator.Instruction inst, double result, long address) throws IOException {
            this.trace(inst);
            this.entry.result = "" + result + " " + FunctionEmulator.hexpad(address);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchAndSave(Emulator em, Emulator.Instruction inst, long returnAddress, long targetAddress) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(targetAddress);
            try {
                this.doTraceBranchAndSave(em, inst, returnAddress, targetAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchOnCondition(Emulator em, Emulator.Instruction inst, boolean branched, long targetAddress) throws IOException {
            this.trace(inst);
            this.entry.result = FunctionEmulator.hexpad(targetAddress);
            try {
                this.doTraceBranchOnCondition(em, inst, branched, targetAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchOnCount(Emulator em, Emulator.Instruction inst, int count) throws IOException {
            this.trace(inst);
            this.entry.result = "" + count;
            this.recordOrPrint(this.entry);
        }
    }

    public static interface CallbackFunction {
        public long call(FunctionEmulator var1) throws IOException, CallOriginalException;
    }

    public static class CallOriginalException
    extends Exception {
    }

    class Replace {
        long retVal;
        boolean protect;

        Replace(long retVal, boolean protect) {
            this.retVal = retVal;
            this.protect = protect;
        }
    }

    public class TraceEntry {
        public long address;
        public long offset;
        public String instruction;
        public String opcode;
        public String args;
        public String result = "";

        TraceEntry(long address, long offset, String instruction) {
            int i;
            this.instruction = instruction;
            this.address = address;
            this.offset = offset;
            if (i != -1) {
                this.opcode = instruction.substring(0, i);
                for (i = instruction.indexOf(32); i < instruction.length() && instruction.charAt(i) == ' '; ++i) {
                }
                this.args = i < instruction.length() ? instruction.substring(i) : "";
            } else {
                this.opcode = instruction;
                this.args = "";
            }
        }

        public String toString() {
            String off = FunctionEmulator.this.printOffsets ? " + " + FunctionEmulator.hexpad(this.offset).substring(5) : "";
            return FunctionEmulator.hexpad(this.address) + off + ": " + this.instruction + " " + this.result;
        }
    }

    public class Function {
        private String name;
        private Function parent;
        private ArrayList children = new ArrayList();
        private HashMap childMap = new HashMap();

        Function(String name, Function parent) {
            this.name = name;
            this.parent = parent;
        }

        public Function getParent() {
            return this.parent;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public String getName() {
            return this.name;
        }

        public Function addChild(String childName) {
            Function child = (Function)this.childMap.get(childName);
            if (child == null) {
                child = new Function(childName, this);
                this.children.add(child);
                this.childMap.put(childName, child);
            }
            return child;
        }
    }
}

