/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.CharConversion;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntegerMap;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectLruCache;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Template;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressSpace
implements Serializable {
    protected Dump dump;
    protected int asid;
    protected IntegerMap addressMap = new IntegerMap();
    private int quickCacheHits;
    private int cacheHits;
    private int cacheMisses;
    private ObjectLruCache blockCache;
    protected long lastBlockAddress;
    private byte[] lastBlock;
    protected long lastButOneBlockAddress;
    private byte[] lastButOneBlock;
    protected AddressRange[] ranges;
    private boolean is64bit;
    private HashMap userMap = new HashMap();
    private long lowestAddress = -1L;
    public static final long WILD_POINTER = -4995072469322842385L;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private static final boolean printStats = Boolean.getBoolean("zebedee.printStats");

    public AddressSpace(Dump dump, int asid) {
        this.dump = dump;
        this.asid = asid;
        this.initialize();
    }

    public Dump getDump() {
        return this.dump;
    }

    public AddressSpace getRootAddressSpace() {
        return this.dump.rootSpace;
    }

    public long getLowestAddress() {
        if (this.lowestAddress == -1L) {
            long[] addresses = this.addressMap.getKeysArray();
            Arrays.sort(addresses);
            this.lowestAddress = addresses[0];
        }
        return this.lowestAddress;
    }

    private void initialize() {
        this.blockCache = new ObjectLruCache(500);
        this.userMap = new HashMap();
        this.lastBlockAddress = -1L;
        this.lastButOneBlockAddress = -1L;
        this.lowestAddress = -1L;
        if (printStats && this.getClass() == AddressSpace.class) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<AddressSpace> clazz = AddressSpace.class;
                    synchronized (AddressSpace.class) {
                        System.out.println("stats for asid " + AddressSpace.hex(AddressSpace.this.asid) + " in dump " + AddressSpace.this.dump.getName() + ":");
                        System.out.println("    cacheMisses = " + AddressSpace.this.cacheMisses);
                        System.out.println("    cacheHits = " + AddressSpace.this.cacheHits);
                        System.out.println("    quickCacheHits = " + AddressSpace.this.quickCacheHits);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public int getAsid() {
        return this.asid;
    }

    public AddressRange[] getAddressRanges() {
        if (this.ranges != null) {
            return this.ranges;
        }
        long[] addresses = this.addressMap.getKeysArray();
        Arrays.sort(addresses);
        long startAddress = 0L;
        long lastAddress = 0L;
        Vector<AddressRange> v = new Vector<AddressRange>();
        for (int i = 0; i < addresses.length; ++i) {
            if (i == 0) {
                startAddress = addresses[0];
            } else if (addresses[i] != lastAddress + 4096L) {
                v.add(new AddressRange(startAddress, lastAddress + 4096L - startAddress));
                startAddress = addresses[i];
            }
            lastAddress = addresses[i];
        }
        v.add(new AddressRange(startAddress, lastAddress + 4096L - startAddress));
        this.ranges = v.toArray(new AddressRange[0]);
        return this.ranges;
    }

    public AddressRange[] getUnusedAddressRanges() {
        this.getAddressRanges();
        AddressRange[] unused = new AddressRange[this.ranges.length - 1];
        for (int i = 0; i < unused.length; ++i) {
            long start = this.ranges[i].getEndAddress() + 1L;
            long end = this.ranges[i + 1].getStartAddress() - 1L;
            unused[i] = new AddressRange(start, end - start);
        }
        return unused;
    }

    public AddressSpaceImageInputStream getImageInputStream() {
        return new AddressSpaceImageInputStream(this);
    }

    private void checkIfWild(long address) {
        assert (address != -4995072469322842385L);
        assert ((int)address != -559038737);
        assert (address < -4995072469322846481L || address > -4995072469322838289L) : AddressSpace.hex(address);
        assert ((int)address < -559042833 || (int)address > -559034641) : AddressSpace.hex((int)address);
    }

    protected long roundToPage(long address) {
        this.checkIfWild(address);
        return address & 0xFFFFFFFFFFFFF000L;
    }

    private long offset(long address) {
        long blockAddress = this.roundToPage(address);
        long offset = this.addressMap.get(blockAddress);
        if (offset == -1L) {
            if (this.asid != 1 && (offset = this.dump.rootSpace.addressMap.get(blockAddress)) != -1L) {
                log.fine("found address " + AddressSpace.hex(address) + " in root address space");
            }
            if (offset == -1L && this.asid != -910042680 && this.dump.highVirtualSharedSpace != null && (offset = this.dump.highVirtualSharedSpace.addressMap.get(blockAddress)) != -1L) {
                log.fine("found address " + AddressSpace.hex(address) + " in high virtual shared address space");
            }
            if (offset == -1L) {
                log.fine("block address " + AddressSpace.hex(address) + " not in dump");
            }
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(long address, byte[] buf) throws IOException {
        assert (buf.length <= 4096) : buf.length;
        long offset = this.offset(address);
        if (offset == -1L) {
            throw new IOException("block address " + AddressSpace.hex(address) + " not in dump");
        }
        Dump dump = this.dump;
        synchronized (dump) {
            this.dump.seek(offset);
            this.dump.readFully(buf);
        }
    }

    public boolean isValidAddress(long address) {
        try {
            return this.offset(address) != -1L;
        }
        catch (Throwable e) {
            return false;
        }
    }

    final synchronized byte[] getBlockFromQuickCache(long address) {
        if (address == this.lastBlockAddress) {
            return this.lastBlock;
        }
        if (address == this.lastButOneBlockAddress) {
            return this.lastButOneBlock;
        }
        return null;
    }

    final synchronized void putBlockInQuickCache(long address, byte[] block) {
        assert ((address & 0xFFFL) == 0L);
        this.lastButOneBlockAddress = this.lastBlockAddress;
        this.lastButOneBlock = this.lastBlock;
        this.lastBlockAddress = address;
        this.lastBlock = block;
    }

    public final byte[] getBlock(long address) throws IOException {
        byte[] b = this.getBlockFromQuickCache(address = this.roundToPage(address));
        return b != null ? b : this.getBlockFromCacheOrDisk(address);
    }

    protected byte[] getBlockFromCacheOrDisk(long address) throws IOException {
        byte[] block = (byte[])this.blockCache.get(address);
        if (block == null) {
            block = new byte[4096];
            this.read(address, block);
            this.blockCache.put(address, block);
        }
        this.putBlockInQuickCache(address, block);
        return block;
    }

    public int read(long address) throws IOException {
        return this.getBlock(address)[(int)address & 0xFFF] & 0xFF;
    }

    public int readInt(long address) throws IOException {
        int offset = (int)address & 0xFFF;
        try {
            if (offset < 4093) {
                return Dump.readInt(this.getBlock(address), offset);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("address " + AddressSpace.hex(address) + " not in dump");
        }
        int ch1 = this.read(address++);
        int ch2 = this.read(address++);
        int ch3 = this.read(address++);
        int ch4 = this.read(address++);
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    public int readUnsignedByte(long address) throws IOException {
        return this.readInt(address) >>> 24;
    }

    public byte readByte(long address) throws IOException {
        return (byte)this.readUnsignedByte(address);
    }

    public int readUnsignedShort(long address) throws IOException {
        return this.readInt(address) >>> 16;
    }

    public short readShort(long address) throws IOException {
        return (short)this.readUnsignedShort(address);
    }

    public long readUnsignedInt(long address) throws IOException {
        long i = this.readInt(address);
        return i & 0xFFFFFFFFL;
    }

    public long readLong(long address) throws IOException {
        int offset = (int)address & 0xFFF;
        try {
            if (offset < 4089) {
                return Dump.readLong(this.getBlock(address), offset);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("address " + AddressSpace.hex(address) + " not in dump");
        }
        long upper = this.readInt(address);
        long lower = this.readInt(address + 4L);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    public long readWord(long address) throws IOException {
        return this.is64bit ? this.readLong(address) : (long)this.readInt(address) & 0xFFFFFFFFL;
    }

    public long readWord(long address, boolean is64bitMode) throws IOException {
        return is64bitMode ? this.readLong(address) : (long)this.readInt(address) & 0xFFFFFFFFL;
    }

    public int getWordLength() {
        return this.is64bit ? 8 : 4;
    }

    public void read(long address, byte[] b, int off, int len) throws IOException {
        while (true) {
            int blockOffset;
            byte[] block;
            int blockRemainder;
            if (len <= (blockRemainder = (block = this.getBlock(address)).length - (blockOffset = (int)(address & Integer.MAX_VALUE) % block.length))) {
                System.arraycopy(block, blockOffset, b, off, len);
                return;
            }
            System.arraycopy(block, blockOffset, b, off, blockRemainder);
            address += (long)blockRemainder;
            off += blockRemainder;
            len -= blockRemainder;
        }
    }

    public String readEbcdicString(long address, int length) throws IOException {
        byte[] b = new byte[length];
        this.read(address, b, 0, length);
        return CharConversion.getEbcdicString(b);
    }

    public String readEbcdicString(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readEbcdicString(address + 2L, length);
    }

    public String readEbcdicCString(long address) throws IOException {
        int length = 0;
        long addr = address;
        while (this.read(addr) != 0) {
            ++addr;
            ++length;
        }
        return this.readEbcdicString(address, length);
    }

    public String readAsciiString(long address, int length) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append((char)this.read(address++));
        }
        return buf.toString();
    }

    public String readAsciiCString(long address) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = this.read(address++)) != 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public String readAsciiString(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readAsciiString(address + 2L, length);
    }

    public String readUtf8String(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readAsciiString(address + 2L, length);
    }

    public long readLong(long address, Template template, String field) throws NoSuchFieldException, IOException {
        return template.getField(field).readLong(this.getImageInputStream(), address);
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public void setIs64bit(boolean is64bit) {
        log.fine("Set address space " + this.asid + " as " + (is64bit ? "64-bit" : "32-bit"));
        this.is64bit = is64bit;
    }

    void mapAddressToFileOffset(long address, long offset) {
        if (this.addressMap.get(address) != -1L) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("duplicate address 0x" + AddressSpace.hex(address) + " for asid " + this.asid);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("mapping address 0x" + AddressSpace.hex(address) + " to offset " + AddressSpace.hex(offset) + " for asid " + this.asid);
        }
        this.addressMap.put(address, offset);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    public String toString() {
        return AddressSpace.hex(this.asid);
    }

    void setDump(Dump dump) {
        this.dump = dump;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.asid);
        out.writeObject(this.addressMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.asid = in.readInt();
        this.addressMap = (IntegerMap)in.readObject();
        this.initialize();
    }

    public boolean equals(Object obj) {
        AddressSpace space = (AddressSpace)obj;
        return space.asid == this.asid && space.dump.equals(this.dump);
    }

    public int hashCode() {
        return this.asid * this.dump.hashCode();
    }
}

