/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.SearchableMemory;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaNotFound;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllFunction;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllVariable;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Edb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.FileFormatException;
import com.ibm.jzos.ZFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class TDumpReader
implements ICoreFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;

    public boolean validDump(byte[] data, long filesize) {
        int signature = 0xFF000000 & data[0] << 24 | 0xFF0000 & data[1] << 16 | 0xFF00 & data[2] << 8 | 0xFF & data[3];
        return signature == -992349888 || signature == -992349632;
    }

    @Override
    public ICore processDump(String path) throws InvalidDumpFormatException, IOException {
        return new DumpAdapter(new Dump(path));
    }

    @Override
    public ICore processDump(ImageInputStream in) throws InvalidDumpFormatException, IOException {
        return new DumpAdapter(new Dump(in));
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String path) throws IOException {
        if (!new File(path).exists()) {
            if (System.getProperty("os.name").toLowerCase().indexOf("z/os") == -1) {
                return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
            }
            if (!ZFile.exists((String)("//'" + path + "'"))) {
                return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
            }
        }
        try {
            new Dump(path, false).close();
            return ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
        }
        catch (FileFormatException ex) {
            return ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream in) throws IOException {
        try {
            in.seek(0L);
            int header = in.readInt();
            if (header == -992349888 || header == -992349632) {
                ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
                return dumpTestResult;
            }
            ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
            return dumpTestResult;
        }
        catch (FileFormatException ex) {
            ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
            return dumpTestResult;
        }
        catch (IOException ex) {
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        finally {
            in.seek(0L);
        }
    }

    private static String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static class DSAAdapter
    implements IOSStackFrame {
        private final DsaStackFrame dsa;
        private final EdbAdapter edb;

        public DSAAdapter(DsaStackFrame dsa, EdbAdapter edb) {
            this.dsa = dsa;
            this.edb = edb;
        }

        public Symbol getSymbol() {
            return new Symbol(this.dsa.getEntryName(), this.dsa.getEntryPoint());
        }

        @Override
        public long getBasePointer() {
            return this.dsa.getDsaAddress();
        }

        @Override
        public long getInstructionPointer() {
            return this.dsa.getEntryPoint() + this.dsa.getEntryOffset();
        }

        @Override
        public long getStackPointer() {
            return this.dsa.getRegisterSet().getRegister(5);
        }
    }

    private static class TCBAdapter
    implements IOSThread {
        private static final int NUMBER_OF_GP_REGISTERS = 16;
        private final Tcb tcb;
        private final Caa caa;
        private final Properties props = new Properties();
        private final EdbAdapter edb;
        private List<DSAAdapter> stackFrames = new LinkedList<DSAAdapter>();
        private boolean stacksWalked = false;

        public TCBAdapter(Tcb tcb, Caa caa, EdbAdapter edb) {
            this.tcb = tcb;
            this.caa = caa;
            this.edb = edb;
            this.props.setProperty("TCB", TDumpReader.format(tcb.address()));
            this.props.setProperty("CAA", TDumpReader.format(caa.address()));
            this.props.setProperty("EDB", TDumpReader.format(caa.getEdb().address()));
            try {
                this.props.setProperty("PTHREADID", TDumpReader.format(caa.getPthreadId()));
            }
            catch (IOException e) {
                this.props.setProperty("PTHREADID", "unknown");
            }
            try {
                this.props.setProperty("Stack direction", caa.ceecaa_stackdirection() == 0 ? "up" : "down");
                this.props.setProperty("CAA CEL level", TDumpReader.format(caa.ceecaalevel()));
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                int code = tcb.space().readInt(tcb.address() + 16L);
                this.props.setProperty("Task Completion Code", TDumpReader.format(code));
            }
            catch (IOException code) {
                // empty catch block
            }
            try {
                long psw = tcb.getRegisters().getPSW();
                String pswn = null;
                switch ((int)(psw >> 31) & 3) {
                    case 0: {
                        pswn = "PSW:24";
                        break;
                    }
                    case 1: {
                        pswn = "PSW:31";
                        break;
                    }
                    default: {
                        pswn = "PSW:64";
                    }
                }
                this.props.setProperty(pswn, TDumpReader.format(psw));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null != caa.getFailingRegisters()) {
                this.props.setProperty("FailingRegisters", "true");
            }
            try {
                this.props.setProperty("IFA Enabled", tcb.isIFAEnabled() ? "yes" : "no");
                this.props.setProperty("WEBFLAG2", String.format("0x%02x", tcb.getIFAFlags()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Map<Long, String> getStackSymbols() {
            this.getStackFrames();
            HashMap<Long, String> symbols = new HashMap<Long, String>();
            for (DSAAdapter frame : this.getStackFrames()) {
                Symbol sym = frame.getSymbol();
                symbols.put(sym.getAddress(), sym.getName());
            }
            return symbols;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            List<DSAAdapter> frames = this.getStackFrames();
            HashSet<MemoryRange> ranges = new HashSet<MemoryRange>();
            for (IOSStackFrame iOSStackFrame : frames) {
                IMemoryRange range = this.edb.getAddressSpace().getRangeForAddress(iOSStackFrame.getBasePointer());
                if (range == null) continue;
                ranges.add(new MemoryRange(this.edb.getAddressSpace(), range, "Stack"));
            }
            return ranges;
        }

        @Override
        public Properties getProperties() {
            return this.props;
        }

        public List<IRegister> getRegisters() {
            RegisterSet rs = new RegisterSet();
            DsaStackFrame dsa = this.caa.getCurrentFrame();
            if (dsa != null && dsa.getRegisterSet() != null) {
                rs = dsa.getRegisterSet();
            } else {
                try {
                    rs = this.tcb.getRegisters();
                }
                catch (IOException e) {
                    try {
                        rs = this.tcb.getRegistersFromBPXGMSTA();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ArrayList<IRegister> regs = new ArrayList<IRegister>(17);
            long psw = rs.getPSW();
            regs.add(new Register("PSW", psw));
            for (int i = 0; i < 16; ++i) {
                regs.add(new Register("R" + i, rs.getRegister(i)));
            }
            return regs;
        }

        public List<DSAAdapter> getStackFrames() {
            if (!this.stacksWalked) {
                DsaStackFrame dsa = null;
                try {
                    dsa = this.caa.getCurrentFrame();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dsa != null) {
                    try {
                        while (dsa != null) {
                            this.stackFrames.add(new DSAAdapter(dsa, this.edb));
                            dsa = dsa.getParentFrame();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stacksWalked = true;
            }
            return this.stackFrames;
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            try {
                return this.caa.getPthreadId() >>> 32;
            }
            catch (IOException ex) {
                throw new CorruptDataException(ex);
            }
        }

        @Override
        public long getInstructionPointer() {
            DSAAdapter dsa = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dsa = this.stackFrames.get(0);
            } else {
                try {
                    dsa = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error e) {
                    logger.log(Level.FINE, "Failed to read dsa from core", e);
                    return 0L;
                }
            }
            return dsa.getInstructionPointer();
        }

        @Override
        public long getBasePointer() {
            DSAAdapter dsa = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dsa = this.stackFrames.get(0);
            } else {
                try {
                    dsa = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error e) {
                    logger.log(Level.FINE, "Failed to read dsa from core", e);
                    return 0L;
                }
            }
            return dsa.getBasePointer();
        }

        @Override
        public long getStackPointer() {
            DSAAdapter dsa = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dsa = this.stackFrames.get(0);
            } else {
                try {
                    dsa = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error e) {
                    logger.log(Level.FINE, "Failed to read dsa from core", e);
                    return 0L;
                }
            }
            return dsa.getStackPointer();
        }
    }

    private static class AddressRangeAdapter
    extends ProtectedMemoryRange {
        private final AddressSpace addressSpace;
        private final String name;

        public AddressRangeAdapter(AddressSpace space, AddressRange range, String name) {
            super(range.getStartAddress(), range.getLength());
            this.addressSpace = space;
            this.name = name;
        }

        public AddressRangeAdapter(AddressSpace space, AddressRange range) {
            this(space, range, null);
        }

        @Override
        public int getAddressSpaceId() {
            return this.addressSpace.getAsid();
        }

        @Override
        public String toString() {
            return String.format("TDumpReader address range from 0x%X to 0x%X in address space %x", this.getBaseAddress(), this.getTopAddress(), this.getAddressSpaceId());
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.addressSpace == null ? 0 : this.addressSpace.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AddressRangeAdapter)) {
                return false;
            }
            AddressRangeAdapter other = (AddressRangeAdapter)obj;
            if (this.addressSpace == null ? other.addressSpace != null : !this.addressSpace.equals(other.addressSpace)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static class EdbAdapter
    implements IProcess {
        private final AddressSpaceAdapter as;
        private final Edb edb;
        private final Caa caa;
        private IModule executable;
        private List<IModule> modules = new LinkedList<IModule>();
        private boolean modulesLoaded = false;
        private List<TCBAdapter> threads = null;

        private EdbAdapter(AddressSpaceAdapter as, Edb edb, Caa caa) {
            this.edb = edb;
            this.as = as;
            this.caa = caa;
        }

        @Override
        public int bytesPerPointer() {
            return this.caa.is64bit() ? 8 : 4;
        }

        @Override
        public long getPointerAt(long address) throws MemoryFault {
            if (this.bytesPerPointer() == 8) {
                return this.getLongAt(address);
            }
            return this.getIntAt(address);
        }

        @Override
        public AddressSpaceAdapter getAddressSpace() {
            return this.as;
        }

        @Override
        public long findPattern(byte[] whatBytes, int alignment, long startFrom) {
            return this.as.findPattern(whatBytes, alignment, startFrom);
        }

        @Override
        public byte getByteAt(long address) throws MemoryFault {
            return this.as.getByteAt(address);
        }

        @Override
        public ByteOrder getByteOrder() {
            return this.as.getByteOrder();
        }

        @Override
        public int getBytesAt(long address, byte[] buffer) throws MemoryFault {
            return this.as.getBytesAt(address, buffer);
        }

        @Override
        public int getBytesAt(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            return this.as.getBytesAt(address, buffer, offset, length);
        }

        @Override
        public int getIntAt(long address) throws MemoryFault {
            return this.as.getIntAt(address);
        }

        @Override
        public long getLongAt(long address) throws MemoryFault {
            return this.as.getLongAt(address);
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return this.as.getMemoryRanges();
        }

        @Override
        public short getShortAt(long address) throws MemoryFault {
            return this.as.getShortAt(address);
        }

        public String toString() {
            return "EdbAdapter for EDB 0x" + Long.toHexString(this.edb.address());
        }

        @Override
        public String getCommandLine() throws DataUnavailableException {
            throw new DataUnavailableException("Command line not available on this platform");
        }

        @Override
        public Properties getEnvironmentVariables() throws CorruptDataException {
            try {
                return this.edb.getEnvVars();
            }
            catch (IOException e) {
                throw new CorruptDataException(e);
            }
        }

        @Override
        public IModule getExecutable() throws CorruptDataException {
            this.loadModules();
            return this.executable;
        }

        public List<IModule> getModules() throws CorruptDataException {
            this.loadModules();
            return Collections.unmodifiableList(this.modules);
        }

        private void loadModules() throws CorruptDataException {
            if (this.modulesLoaded) {
                return;
            }
            AddressRange[] rr = this.as.addressSpace.getAddressRanges();
            Map<Long, String> stackSyms = this.getStackSymbols();
            try {
                HashMap<Long, Dll> closestDlls = new HashMap<Long, Dll>();
                for (Long addr : stackSyms.keySet()) {
                    long address = addr;
                    Dll closest = this.closestDll(this.edb, address);
                    closestDlls.put(addr, closest);
                }
                boolean firstPass = true;
                for (Dll dll = this.edb.getFirstDll(); dll != null; dll = dll.getNext()) {
                    long loadAddress;
                    int i;
                    DllFunction[] f = dll.getFunctions();
                    DllVariable[] g = dll.getVariables();
                    String dllname = dll.getName();
                    ArrayList<Symbol> symbols = new ArrayList<Symbol>();
                    long[][] usedTextRangeLimits = new long[rr.length][2];
                    long[][] usedDataRangeLimits = new long[rr.length][2];
                    for (i = 0; i < rr.length; ++i) {
                        usedTextRangeLimits[i][0] = Long.MAX_VALUE;
                        usedDataRangeLimits[i][0] = Long.MAX_VALUE;
                    }
                    for (i = 0; i < f.length; ++i) {
                        symbols.add(new Symbol(f[i].name, f[i].address));
                        this.findRange(f[i].address, usedTextRangeLimits, rr);
                    }
                    for (i = 0; i < g.length; ++i) {
                        symbols.add(new Symbol(g[i].getName(), g[i].getAddress()));
                        this.findRange(g[i].getAddress(), usedDataRangeLimits, rr);
                    }
                    Iterator<Long> i2 = stackSyms.keySet().iterator();
                    while (i2.hasNext()) {
                        int r;
                        Long addr = i2.next();
                        long address = addr;
                        Dll closest = (Dll)closestDlls.get(addr);
                        if (closest == null || !dll.getName().equals(closest.getName()) || (r = this.findRange(address, rr)) < 0 || address <= usedTextRangeLimits[r][0] || address >= usedTextRangeLimits[r][1]) continue;
                        String name = stackSyms.get(addr);
                        symbols.add(new Symbol(name, address));
                        i2.remove();
                    }
                    ArrayList<MemoryRange> sections = new ArrayList<MemoryRange>();
                    for (int i3 = 0; i3 < rr.length; ++i3) {
                        long size;
                        long base;
                        if (usedTextRangeLimits[i3][1] != 0L) {
                            base = this.roundToPage(usedTextRangeLimits[i3][0], Direction.DOWN);
                            size = this.roundToPage(usedTextRangeLimits[i3][1], Direction.UP) - base;
                            sections.add(new MemoryRange(this.as, base, size, ".text"));
                        }
                        if (usedDataRangeLimits[i3][1] == 0L) continue;
                        base = this.roundToPage(usedDataRangeLimits[i3][0], Direction.DOWN);
                        size = this.roundToPage(usedDataRangeLimits[i3][1], Direction.UP) - base;
                        sections.add(new MemoryRange(this.as, base, size, ".data"));
                    }
                    try {
                        loadAddress = dll.getLoadAddress();
                    }
                    catch (Error e) {
                        loadAddress = Long.MAX_VALUE;
                        for (int i4 = 0; i4 < f.length; ++i4) {
                            loadAddress = Math.min(f[i4].address, loadAddress);
                        }
                        loadAddress = loadAddress == Long.MAX_VALUE ? 0L : this.roundToPage(loadAddress, Direction.DOWN);
                    }
                    Properties props = new Properties();
                    props.setProperty("Load address", TDumpReader.format(loadAddress));
                    props.setProperty("Writable Static Area address", TDumpReader.format(dll.getWsa()));
                    Module module = new Module(this, dllname, symbols, sections, loadAddress, props);
                    if (firstPass) {
                        this.executable = module;
                        firstPass = false;
                        continue;
                    }
                    this.modules.add(module);
                }
                if (stackSyms.size() > 0) {
                    String dllname = "ExtraSymbolsModule";
                    long loadAddress = Long.MAX_VALUE;
                    ArrayList<Symbol> symbols = new ArrayList<Symbol>();
                    long[][] usedTextRangeLimits = new long[rr.length][2];
                    for (int i = 0; i < rr.length; ++i) {
                        usedTextRangeLimits[i][0] = Long.MAX_VALUE;
                    }
                    Iterator<Long> i = stackSyms.keySet().iterator();
                    while (i.hasNext()) {
                        Long addr = i.next();
                        long address = addr;
                        loadAddress = Math.min(address, loadAddress);
                        this.findRange(address, usedTextRangeLimits, rr);
                        String name = stackSyms.get(addr);
                        symbols.add(new Symbol(name, address));
                        i.remove();
                    }
                    loadAddress = loadAddress == Long.MAX_VALUE ? 0L : this.roundToPage(loadAddress, Direction.DOWN);
                    Properties props = new Properties();
                    props.setProperty("Load address", TDumpReader.format(loadAddress));
                    ArrayList<MemoryRange> sections = new ArrayList<MemoryRange>();
                    for (int i5 = 0; i5 < rr.length; ++i5) {
                        if (usedTextRangeLimits[i5][1] == 0L) continue;
                        long base = this.roundToPage(usedTextRangeLimits[i5][0], Direction.DOWN);
                        long size = this.roundToPage(usedTextRangeLimits[i5][1], Direction.UP) - base;
                        sections.add(new MemoryRange(this.as, base, size, ".text"));
                    }
                    Module mod = new Module(this, "ExtraSymbolsModule", symbols, sections, loadAddress, props);
                    this.modules.add(mod);
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem for Zebedee finding module information", e);
            }
            this.modulesLoaded = true;
        }

        private Map<Long, String> getStackSymbols() throws CorruptDataException {
            HashMap<Long, String> result = new HashMap<Long, String>();
            for (TCBAdapter thread : this.getThreads()) {
                result.putAll(thread.getStackSymbols());
            }
            return result;
        }

        private void findRange(long address, long[][] usedRangeLimits, AddressRange[] rr) {
            int r = this.findRange(address, rr);
            if (r >= 0) {
                usedRangeLimits[r][0] = Math.min(usedRangeLimits[r][0], address);
                usedRangeLimits[r][1] = Math.max(usedRangeLimits[r][1], address);
            }
        }

        private int findRange(long routine, AddressRange[] rr) {
            for (int i = 0; i < rr.length; ++i) {
                if (rr[i].getStartAddress() > routine || routine > rr[i].getEndAddress()) continue;
                logger.fine("Found address " + TDumpReader.format(routine) + " at " + TDumpReader.format(rr[i].getStartAddress()) + ":" + TDumpReader.format(rr[i].getEndAddress()));
                return i;
            }
            logger.fine("Didn't find address " + TDumpReader.format(routine));
            return -2;
        }

        private long roundToPage(long address, Direction direction) {
            if (direction == Direction.DOWN) {
                return address & 0xFFFFFFFFFFFFF000L;
            }
            return (address & 0xFFFFFFFFFFFFF000L) + 4096L;
        }

        private Dll closestDll(Edb edb, long address) throws IOException {
            Dll closestDll = null;
            long closestDist = Long.MAX_VALUE;
            for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
                try {
                    DllFunction[] f = dll.getFunctions();
                    for (int i = 0; i < f.length; ++i) {
                        long dist = Math.abs(f[i].address - address);
                        if (dist >= closestDist) continue;
                        closestDll = dll;
                        closestDist = dist;
                    }
                    DllVariable[] g = dll.getVariables();
                    for (int i = 0; i < g.length; ++i) {
                        long dist = Math.abs(g[i].getAddress() - address);
                        if (dist >= closestDist) continue;
                        closestDll = dll;
                        closestDist = dist;
                    }
                    continue;
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Skipping DDL due to IOException ", e);
                }
            }
            return closestDll;
        }

        @Override
        public long getProcessId() throws CorruptDataException {
            return this.edb.address();
        }

        @Override
        public boolean isExecutable(long address) {
            return this.as.isExecutable(address);
        }

        @Override
        public boolean isReadOnly(long address) {
            return this.as.isReadOnly(address);
        }

        @Override
        public boolean isShared(long address) {
            return this.as.isShared(address);
        }

        @Override
        public Properties getProperties(long address) {
            return this.as.getProperties(address);
        }

        @Override
        public String getProcedureNameForAddress(long address) throws CorruptDataException, DataUnavailableException {
            return this.getProcedureNameForAddress(address, false);
        }

        @Override
        public String getProcedureNameForAddress(long address, boolean dtfjFormat) throws CorruptDataException, DataUnavailableException {
            ISymbol closestSymbol = null;
            IModule closestModule = null;
            long diff = Long.MAX_VALUE;
            for (IModule thisModule : this.getModules()) {
                for (ISymbol iSymbol : thisModule.getSymbols()) {
                    long thisDiff;
                    if (!Addresses.lessThan(iSymbol.getAddress(), address) || (thisDiff = address - iSymbol.getAddress()) >= diff) continue;
                    diff = thisDiff;
                    closestSymbol = iSymbol;
                    closestModule = thisModule;
                }
            }
            if (closestSymbol != null) {
                return closestModule.getName() + "::" + closestSymbol.getName() + "+0x" + Long.toHexString(diff);
            }
            return "<unknown>";
        }

        public List<TCBAdapter> getThreads() throws CorruptDataException {
            if (this.threads == null) {
                Tcb[] tcbs;
                LinkedList<TCBAdapter> threadsList = new LinkedList<TCBAdapter>();
                for (Tcb tcb : tcbs = Tcb.getTcbs(this.as.addressSpace)) {
                    if (null == tcb) continue;
                    Caa caa = null;
                    try {
                        caa = new Caa(tcb);
                    }
                    catch (CaaNotFound e) {
                        continue;
                    }
                    if (caa.getEdb().address() != this.edb.address()) continue;
                    threadsList.add(new TCBAdapter(tcb, caa, this));
                }
                this.threads = Collections.unmodifiableList(threadsList);
            }
            return this.threads;
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caa == null ? 0 : this.caa.hashCode());
            result = 31 * result + (this.edb == null ? 0 : this.edb.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EdbAdapter)) {
                return false;
            }
            EdbAdapter other = (EdbAdapter)obj;
            if (this.caa == null ? other.caa != null : !this.caa.equals(other.caa)) {
                return false;
            }
            return !(this.edb == null ? other.edb != null : !this.edb.equals(other.edb));
        }

        @Override
        public int getSignalNumber() throws DataUnavailableException {
            throw new DataUnavailableException("Signal number not available on z/OS");
        }

        @Override
        public boolean isFailingProcess() throws DataUnavailableException {
            try {
                return this.caa.getTcb().tcbcmp() != 0L;
            }
            catch (IOException e) {
                throw new DataUnavailableException("Couldn't determine TCB CMP status", e);
            }
        }

        private static enum Direction {
            DOWN,
            UP;

        }
    }

    private static class AddressSpaceAdapter
    extends SearchableMemory
    implements IAddressSpace {
        private final AddressSpace addressSpace;
        private final ICore reader;
        private Set<IProcess> processes;

        private AddressSpaceAdapter(AddressSpace as, ICore reader) {
            this.addressSpace = as;
            this.reader = reader;
        }

        @Override
        public ICore getCore() {
            return this.reader;
        }

        public Collection<IProcess> getProcesses() {
            this.initializeProcesses();
            if (this.processes != null) {
                return Collections.unmodifiableList(new ArrayList<IProcess>(this.processes));
            }
            return Collections.emptyList();
        }

        private void initializeProcesses() {
            if (this.processes != null) {
                return;
            }
            Tcb[] tc = Tcb.getTcbs(this.addressSpace);
            if (tc != null) {
                this.processes = new HashSet<IProcess>();
                HashSet<Edb> knownEdbs = new HashSet<Edb>();
                for (int i = 0; i < tc.length; ++i) {
                    try {
                        Caa ca = new Caa(tc[i]);
                        Edb edb = ca.getEdb();
                        if (knownEdbs.contains(edb)) continue;
                        knownEdbs.add(edb);
                        if (edb.getFirstDll() == null) continue;
                        this.processes.add(new EdbAdapter(this, edb, ca));
                        continue;
                    }
                    catch (CaaNotFound caaNotFound) {
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public int getAddressSpaceId() {
            return this.addressSpace.getAsid();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.addressSpace == null ? 0 : this.addressSpace.hashCode());
            result = 31 * result + (this.processes == null ? 0 : this.processes.hashCode());
            result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AddressSpaceAdapter)) {
                return false;
            }
            AddressSpaceAdapter other = (AddressSpaceAdapter)obj;
            if (this.addressSpace == null ? other.addressSpace != null : !this.addressSpace.equals(other.addressSpace)) {
                return false;
            }
            if (this.processes == null ? other.processes != null : !this.processes.equals(other.processes)) {
                return false;
            }
            return !(this.reader == null ? other.reader != null : !this.reader.equals(other.reader));
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }

        @Override
        public byte getByteAt(long address) throws MemoryFault {
            try {
                return this.addressSpace.readByte(address);
            }
            catch (IOException e) {
                throw new MemoryFault(address, (Throwable)e);
            }
        }

        @Override
        public ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }

        @Override
        public int getBytesAt(long address, byte[] buffer) throws MemoryFault {
            return this.getBytesAt(address, buffer, 0, buffer.length);
        }

        @Override
        public int getBytesAt(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            try {
                this.addressSpace.read(address, buffer, offset, length);
            }
            catch (IOException e) {
                throw new MemoryFault(address, (Throwable)e);
            }
            return length;
        }

        @Override
        public int getIntAt(long address) throws MemoryFault {
            try {
                return this.addressSpace.readInt(address);
            }
            catch (IOException e) {
                throw new MemoryFault(address, (Throwable)e);
            }
        }

        @Override
        public long getLongAt(long address) throws MemoryFault {
            try {
                return this.addressSpace.readLong(address);
            }
            catch (IOException e) {
                throw new MemoryFault(address, (Throwable)e);
            }
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            AddressRange[] zebedeeRanges = this.addressSpace.getAddressRanges();
            ArrayList<AddressRangeAdapter> memoryRanges = new ArrayList<AddressRangeAdapter>(zebedeeRanges.length);
            for (AddressRange thisRange : zebedeeRanges) {
                memoryRanges.add(new AddressRangeAdapter(this.addressSpace, thisRange));
            }
            return memoryRanges;
        }

        @Override
        public short getShortAt(long address) throws MemoryFault {
            try {
                return this.addressSpace.readShort(address);
            }
            catch (IOException e) {
                throw new MemoryFault(address, (Throwable)e);
            }
        }

        @Override
        public boolean isExecutable(long address) {
            return false;
        }

        @Override
        public boolean isReadOnly(long address) {
            return false;
        }

        @Override
        public boolean isShared(long address) {
            return false;
        }

        @Override
        public Properties getProperties(long address) {
            return new Properties();
        }

        public IMemoryRange getRangeForAddress(long address) {
            for (IMemoryRange iMemoryRange : this.getMemoryRanges()) {
                if (!iMemoryRange.contains(address)) continue;
                return iMemoryRange;
            }
            return null;
        }
    }

    private static class DumpAdapter
    implements ICore {
        private final Dump _dump;
        private List<IAddressSpace> addressSpaces = null;

        public DumpAdapter(Dump dump) {
            this._dump = dump;
        }

        @Override
        public void close() throws IOException {
            this._dump.close();
        }

        public List<IAddressSpace> getAddressSpaces() {
            if (null == this.addressSpaces) {
                AddressSpace[] zebAddressSpaces = this._dump.getAddressSpaces();
                this.addressSpaces = new ArrayList<IAddressSpace>(zebAddressSpaces.length);
                for (AddressSpace thisAs : zebAddressSpaces) {
                    if (thisAs.getAsid() == 0) continue;
                    this.addressSpaces.add(new AddressSpaceAdapter(thisAs, this));
                }
            }
            return this.addressSpaces;
        }

        @Override
        public String getDumpFormat() {
            return "tdump";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DumpAdapter)) {
                return false;
            }
            DumpAdapter other = (DumpAdapter)obj;
            return !(this._dump == null ? other._dump != null : !this._dump.equals(other._dump));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dump == null ? 0 : this._dump.hashCode());
            return result;
        }

        @Override
        public Properties getProperties() {
            Properties properties = new Properties();
            properties.setProperty("core.creation.time", Long.toString(this._dump.getCreationDate().getTime()));
            properties.setProperty("cpu.type", "s390");
            properties.setProperty("cpu.subtype", "");
            properties.setProperty("system.type", "z/OS");
            return properties;
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }
    }
}

