/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.Address64;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class ELF64FileReader
extends ELFFileReader {
    public ELF64FileReader(File f, ByteOrder byteOrder, long offset) throws FileNotFoundException, IOException, InvalidDumpFormatException {
        super(f, byteOrder, offset);
    }

    public ELF64FileReader(File f, ByteOrder byteOrder) throws FileNotFoundException, IOException, InvalidDumpFormatException {
        super(f, byteOrder, 0L);
    }

    public ELF64FileReader(ImageInputStream in, long offset) throws IOException, InvalidDumpFormatException {
        super(in, offset);
    }

    public boolean validDump(byte[] data, long filesize) {
        return 127 == data[0] && 69 == data[1] && 76 == data[2] && 70 == data[3] && 2 == data[4];
    }

    @Override
    protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
        int type2 = this.is.readInt();
        int flags = this.is.readInt();
        long fileOffset = this.is.readLong();
        long virtualAddress = this.is.readLong();
        long physicalAddress = this.is.readLong();
        long fileSize = this.is.readLong();
        long memorySize = this.is.readLong();
        long alignment = this.is.readLong();
        return new ProgramHeaderEntry(type2, fileOffset, fileSize, virtualAddress, physicalAddress, memorySize, flags, alignment, this);
    }

    @Override
    protected long padToWordBoundary(long l) {
        return (l + 7L) / 8L * 8L;
    }

    @Override
    protected long readElfWord() throws IOException {
        return this.is.readLong();
    }

    @Override
    protected Address readElfWordAsAddress() throws IOException {
        return new Address64(this.is.readLong());
    }

    @Override
    protected int addressSizeBits() {
        return 64;
    }

    @Override
    protected List<ELFSymbol> readSymbolsAt(SectionHeaderEntry entry) throws IOException {
        if (0L != entry.size % 24L) {
            return Collections.emptyList();
        }
        this.seek(entry.offset);
        long count = (int)(entry.size / 24L);
        count = Math.min(Math.abs(count), 8096L);
        ArrayList<ELFSymbol> symbols = new ArrayList<ELFSymbol>((int)count);
        for (long i = 0L; i < count; ++i) {
            long name = (long)this.is.readInt() & 0xFFFFFFFFL;
            byte info = this.is.readByte();
            byte other = this.is.readByte();
            int sectionIndex = this.is.readShort() & 0xFFFF;
            long value = this.is.readLong();
            long size = this.is.readLong();
            symbols.add(new ELFSymbol(name, value, size, info, other, sectionIndex));
        }
        return symbols;
    }
}

