/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseAIXOSThread
implements IOSThread {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    protected final IProcess process;
    private List<IOSStackFrame> frames;

    protected BaseAIXOSThread(IProcess process) {
        this.process = process;
    }

    @Override
    public List<? extends IOSStackFrame> getStackFrames() {
        if (this.frames == null) {
            this.walkStack();
        }
        return Collections.unmodifiableList(this.frames);
    }

    private void walkStack() {
        this.frames = new LinkedList<IOSStackFrame>();
        long stackPointer = this.getStackPointer();
        long instructionPointer = this.getInstructionPointer();
        if (0L == instructionPointer || !this.isValidAddress(instructionPointer)) {
            instructionPointer = this.getBasePointer();
        }
        try {
            if (0L != instructionPointer && 0L != stackPointer && this.isValidAddress(instructionPointer) && this.isValidAddress(stackPointer)) {
                this.frames.add(new OSStackFrame(stackPointer, instructionPointer));
                long previousStackPointer = -1L;
                long stepping = this.process.bytesPerPointer();
                int loops = 0;
                while (previousStackPointer != stackPointer && loops++ < 256) {
                    previousStackPointer = stackPointer;
                    stackPointer = this.process.getPointerAt(stackPointer);
                    long addressToRead = stackPointer + stepping;
                    instructionPointer = this.process.getPointerAt(addressToRead += stepping);
                    this.frames.add(new OSStackFrame(stackPointer, instructionPointer));
                }
            } else {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.aix.BaseAIXOSThread", "walkStack", "MISSED");
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private boolean isValidAddress(long address) {
        try {
            this.process.getByteAt(address);
            return true;
        }
        catch (MemoryFault e) {
            return false;
        }
    }

    @Override
    public abstract long getStackPointer();

    @Override
    public abstract long getInstructionPointer();

    @Override
    public abstract long getBasePointer();
}

