/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.IModuleFile;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.LibraryResolverFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.aix.AIX32DumpReader;
import com.ibm.j9ddr.corereaders.aix.AIX64DumpReader;
import com.ibm.j9ddr.corereaders.aix.AIXProcessAddressSpace;
import com.ibm.j9ddr.corereaders.aix.ARReader;
import com.ibm.j9ddr.corereaders.aix.BaseAIXOSThread;
import com.ibm.j9ddr.corereaders.aix.XCOFFReader;
import com.ibm.j9ddr.corereaders.memory.BaseModule;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.MissingFileModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public abstract class AIXDumpReader
extends AbstractCoreReader
implements ILibraryDependentCore {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final long FAULTING_THREAD_OFFSET = 216L;
    protected static final int S64BIT = 1;
    private static final long CORE_FILE_VERSION_OFFSET = 4L;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static final long CORE_DUMP_X_PI_FLAGS_2_OFFSET = 1056L;
    private static final int POWER_RS1 = 1;
    private static final int POWER_RSC = 2;
    private static final int POWER_RS2 = 4;
    private static final int POWER_601 = 8;
    private static final int POWER_603 = 32;
    private static final int POWER_604 = 16;
    private static final int POWER_620 = 64;
    private static final int POWER_630 = 128;
    private static final int POWER_A35 = 256;
    private static final int POWER_RS64II = 512;
    private static final int POWER_RS64III = 1024;
    private static final int POWER_4 = 2048;
    private static final int POWER_MPC7450 = 4096;
    private static final int POWER_5 = 8192;
    private int _implementation;
    private int _threadCount;
    private long _threadOffset;
    private long _loaderOffset;
    private long _loaderSize;
    private AIXProcessAddressSpace _process = new AIXProcessAddressSpace(this.is64Bit() ? 8 : 4, ByteOrder.BIG_ENDIAN, this);
    long _highestOffset = -1L;
    private Properties props = new Properties();
    private long _structTopOfStackVirtualAddress;
    private boolean _isTruncated = false;
    private ILibraryResolver resolver = null;
    private ArrayList<XCOFFReader> openFileTracker = new ArrayList();
    private boolean _userInfoLoaded = false;
    private int _pid;
    private int _argc;
    private long _argv;
    private long _environmentHandle;
    private final List<IModule> _modules = new LinkedList<IModule>();
    private IModule _executable;
    private IMemorySource _executableTextSection;

    protected abstract Map<String, Number> readRegisters(long var1) throws IOException;

    protected abstract int readLoaderInfoFlags() throws IOException;

    protected abstract long userInfoOffset();

    protected abstract long threadSize(long var1);

    protected abstract int pointerSize();

    protected abstract long getStackPointerFrom(Map<String, Number> var1);

    protected abstract long getInstructionPointerFrom(Map<String, Number> var1);

    protected abstract long getLinkRegisterFrom(Map<String, Number> var1);

    protected abstract int sizeofTopOfStack();

    protected static boolean isAIXDump(ClosingFileReader f) throws IOException {
        f.seek(8L);
        long fdsinfox = f.readLong();
        long loader = f.readLong();
        long filesize = f.length();
        return fdsinfox > 0L && loader > 0L && loader > fdsinfox && fdsinfox < filesize && loader < filesize;
    }

    public boolean validDump(byte[] data, long filesize) {
        return AIXDumpReader.isAIXDump(data, filesize);
    }

    protected void readCore() throws IOException {
        this.seek(0L);
        this.readByte();
        byte flags = this.readByte();
        if ((flags & 0x80) != 0) {
            this._isTruncated = true;
        }
        this.readShort();
        this.readInt();
        this.readLong();
        this._loaderOffset = this.readLong();
        this._loaderSize = this.readLong();
        this._threadCount = this.readInt();
        this.readInt();
        this._threadOffset = this.readLong();
        long segmentCount = this.readLong();
        long segmentOffset = this.readLong();
        long stackOffset = this.readLong();
        long stackVirtualAddress = this.readLong();
        long stackSize = this.readLong();
        this._structTopOfStackVirtualAddress = stackVirtualAddress + stackSize - (long)this.sizeofTopOfStack();
        DumpMemorySource memoryRange1 = new DumpMemorySource(stackVirtualAddress, stackSize, stackOffset, 0, this, "stack", false, false, false);
        this.addMemorySource(memoryRange1);
        long dataOffset = this.readLong();
        long dataVirtualAddress = this.readLong();
        long dataSize = this.readLong();
        DumpMemorySource memoryRange = new DumpMemorySource(dataVirtualAddress, dataSize, dataOffset, this);
        this.addMemorySource(memoryRange);
        this.readLong();
        this.readLong();
        long vmRegionCount = this.readLong();
        long vmRegionOffset = this.readLong();
        this._implementation = this.readInt();
        this.readInt();
        this.readLong();
        this.readLong();
        this.readBytes(48);
        this.readVMRegions(vmRegionOffset, vmRegionCount);
        this.readSegments(segmentOffset, segmentCount);
        this.readLoaderInfoAsMemoryRanges();
        this.readModules();
        this._isTruncated |= this.checkHighestOffset();
        this.createProperties();
    }

    private void createProperties() {
        this.props.put("system.type", "AIX");
        this.props.put("cpu.type", this.getCPUType());
        this.props.put("cpu.subtype", this.getCPUSubType());
        this.props.put("core.creation.time", (Object)this.getCreationTime());
    }

    public String getCPUType() {
        return "PowerPC";
    }

    public String getCPUSubType() {
        switch (this._implementation) {
            case 1: {
                return "RS1";
            }
            case 2: {
                return "RSC";
            }
            case 4: {
                return "RS2";
            }
            case 8: {
                return "601";
            }
            case 32: {
                return "603";
            }
            case 16: {
                return "604";
            }
            case 64: {
                return "620";
            }
            case 128: {
                return "630";
            }
            case 256: {
                return "A35";
            }
            case 512: {
                return "RS64-II";
            }
            case 1024: {
                return "RS64-III";
            }
            case 2048: {
                return "POWER 4";
            }
            case 4096: {
                return "MPC7450";
            }
            case 8192: {
                return "POWER 5";
            }
        }
        return "";
    }

    public long getCreationTime() {
        return 0L;
    }

    private void addMemorySource(IMemorySource source) {
        DumpMemorySource castedRange;
        if (source instanceof DumpMemorySource && (castedRange = (DumpMemorySource)source).getFileOffset() > this._highestOffset) {
            this._highestOffset = castedRange.getFileOffset();
        }
        this._process.addMemorySource(source);
    }

    private boolean checkHighestOffset() throws IOException {
        if (this._highestOffset != -1L) {
            return !this.checkOffset(this._highestOffset);
        }
        return false;
    }

    private void readVMRegions(long offset, long count) throws IOException {
        this.seek(offset);
        int i = 0;
        while ((long)i < count) {
            long address = this.readLong();
            long size = this.readLong();
            long off = this.readLong();
            DumpMemorySource memoryRange = new DumpMemorySource(address, size, off, 0, this, "anon vm region");
            this.addMemorySource(memoryRange);
            ++i;
        }
    }

    private void readSegments(long offset, long count) throws IOException {
        this.seek(offset);
        int i = 0;
        while ((long)i < count) {
            long address = this.readLong();
            long size = this.readLong();
            long off = this.readLong();
            this.readInt();
            this.readInt();
            DumpMemorySource memoryRange = new DumpMemorySource(address, size, off, 0, this, "anon segment");
            this.addMemorySource(memoryRange);
            ++i;
        }
    }

    private void readLoaderInfoAsMemoryRanges() throws IOException {
        int next = 0;
        long current = this._loaderOffset;
        do {
            this.seek(current += (long)next);
            next = this.readInt();
            this.readLoaderInfoFlags();
            long dataOffset = this.readAddress();
            this.readAddress();
            this.readAddress();
            long dataVirtualAddress = this.readAddress();
            long dataSize = this.readAddress();
            if (0L == dataOffset) continue;
            DumpMemorySource memoryRange = new DumpMemorySource(dataVirtualAddress, dataSize, dataOffset, this);
            this.addMemorySource(memoryRange);
        } while (0 != next && current + (long)next < this._loaderOffset + this._loaderSize);
    }

    protected abstract boolean is64Bit();

    protected abstract long readAddress() throws IOException;

    private void loadUserInfo() throws IOException, MemoryFault {
        if (!this._userInfoLoaded) {
            this.seek(this.userInfoOffset());
            this._pid = this.readInt();
            AIXProcessAddressSpace memory = this.getProcess();
            long workingAddress = this._structTopOfStackVirtualAddress;
            int pointerSize = this.pointerSize() / 8;
            workingAddress += (long)(2 * pointerSize);
            long reg3 = memory.getPointerAt(workingAddress += (long)pointerSize);
            this._argv = memory.getPointerAt(workingAddress += (long)pointerSize);
            this._environmentHandle = memory.getPointerAt(workingAddress += (long)pointerSize);
            this._argc = (int)reg3;
            this._userInfoLoaded = true;
        }
    }

    String getCommandLine() throws CorruptDataException {
        try {
            this.loadUserInfo();
        }
        catch (IOException e1) {
            throw new CorruptDataException(e1);
        }
        AIXProcessAddressSpace memory = this.getProcess();
        int pointerSize = this.pointerSize() / 8;
        if (this._argc > 100) {
            throw new CorruptDataException("Argc too high. Likely corrupt data. Argc=" + this._argc + " structTopOfStackVirtualAddress = 0x" + Long.toHexString(this._structTopOfStackVirtualAddress));
        }
        long[] addresses = new long[this._argc];
        for (int i = 0; i < this._argc; ++i) {
            addresses[i] = memory.getPointerAt(this._argv + (long)(i * pointerSize));
        }
        StringBuffer commandLine = new StringBuffer();
        for (int i = 0; i < this._argc; ++i) {
            try {
                long startingAddress;
                long workingAddress = startingAddress = addresses[i];
                while (memory.getByteAt(workingAddress) != 0) {
                    ++workingAddress;
                }
                int stringLength = (int)(workingAddress - startingAddress);
                byte[] buffer = new byte[stringLength];
                memory.getBytesAt(startingAddress, buffer);
                commandLine.append(new String(buffer, "ASCII"));
                commandLine.append(" ");
                continue;
            }
            catch (MemoryFault e) {
                commandLine.append(" <Fault reading argv[" + i + "] at 0x" + Long.toHexString(addresses[i]) + ">");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return commandLine.toString();
    }

    private void readModules() throws IOException {
        int next = 0;
        long current = this._loaderOffset;
        this.resolver = this.coreFile == null ? LibraryResolverFactory.getResolverForCoreFile(this._fileReader) : LibraryResolverFactory.getResolverForCoreFile(this.coreFile);
        AIXProcessAddressSpace proc = this.getProcess();
        boolean firstModule = true;
        do {
            this.seek(current += (long)next);
            next = this.readInt();
            this.readLoaderInfoFlags();
            this.readAddress();
            long textVirtualAddress = this.readAddress();
            long textSize = this.readAddress();
            long dataVirtualAddress = this.readAddress();
            long dataSize = this.readAddress();
            String fileName = this.readString();
            String objectName = this.readString();
            String moduleName = fileName;
            if (0 < objectName.length()) {
                moduleName = moduleName + "(" + objectName + ")";
            }
            this.loadModule(this.resolver, proc, textVirtualAddress, textSize, dataVirtualAddress, dataSize, fileName, objectName, moduleName, firstModule);
            firstModule = false;
        } while (0 != next && current + (long)next < this._loaderOffset + this._loaderSize);
    }

    @Override
    public void executablePathHint(String path) {
        if (this._executable instanceof MissingFileModule) {
            try {
                if (!this.getFileName(this._executable.getName()).equals(this.getFileName(path))) {
                    return;
                }
            }
            catch (CorruptDataException e1) {
                return;
            }
            this._process.removeMemorySource(this._executableTextSection);
            IModule currentExecutable = this._executable;
            IMemorySource currentExecutableTextSection = this._executableTextSection;
            ILibraryResolver resolver = LibraryResolverFactory.getResolverForCoreFile(this.coreFile);
            AIXProcessAddressSpace proc = this.getProcess();
            try {
                this.seek(this._loaderOffset);
                this.readInt();
                this.readLoaderInfoFlags();
                this.readAddress();
                long textVirtualAddress = this.readAddress();
                long textSize = this.readAddress();
                long dataVirtualAddress = this.readAddress();
                long dataSize = this.readAddress();
                this.readString();
                String fileName = path;
                String objectName = this.readString();
                String moduleName = fileName;
                if (0 < objectName.length()) {
                    moduleName = moduleName + "(" + objectName + ")";
                }
                this.loadModule(resolver, proc, textVirtualAddress, textSize, dataVirtualAddress, dataSize, fileName, objectName, moduleName, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._executable instanceof MissingFileModule) {
                this._process.removeMemorySource(this._executableTextSection);
                this._executableTextSection = currentExecutableTextSection;
                this._process.addMemorySource(this._executableTextSection);
                this._executable = currentExecutable;
            }
        }
    }

    private String getFileName(String name) {
        File f = new File(name);
        return f.getName();
    }

    private void loadModule(ILibraryResolver resolver, IProcess proc, long textVirtualAddress, long textSize, long dataVirtualAddress, long dataSize, String fileName, String objectName, String moduleName, boolean loadingExecutable) {
        BaseModule module;
        IMemorySource text;
        MemoryRange data = new MemoryRange(proc.getAddressSpace(), dataVirtualAddress, dataSize, ".data");
        try {
            LibraryDataSource library = null;
            library = loadingExecutable ? resolver.getLibrary(fileName, true) : resolver.getLibrary(fileName);
            IModuleFile moduleFile = this.loadModuleFile(library, objectName);
            text = moduleFile.getTextSegment(textVirtualAddress, textSize);
            List<? extends ISymbol> symbols = moduleFile.getSymbols(textVirtualAddress);
            LinkedList<IMemoryRange> moduleMemoryRanges = new LinkedList<IMemoryRange>();
            moduleMemoryRanges.add(text);
            moduleMemoryRanges.add(data);
            module = new Module(proc, moduleName, symbols, moduleMemoryRanges, textVirtualAddress, moduleFile.getProperties());
        }
        catch (Exception e) {
            text = new UnbackedMemorySource(textVirtualAddress, textSize, "Native library " + moduleName + " couldn't be found", 0, ".text");
            LinkedList<IMemoryRange> moduleMemoryRanges = new LinkedList<IMemoryRange>();
            moduleMemoryRanges.add(text);
            moduleMemoryRanges.add(data);
            module = new MissingFileModule(proc, moduleName, moduleMemoryRanges);
        }
        this.addMemorySource(text);
        if (loadingExecutable) {
            this._executable = module;
            this._executableTextSection = text;
        } else {
            this._modules.add(module);
        }
    }

    private IModuleFile loadModuleFile(LibraryDataSource source, String objectName) throws IOException {
        XCOFFReader xcoff = null;
        try {
            switch (source.getType()) {
                case FILE: {
                    xcoff = new XCOFFReader(source.getFile());
                    break;
                }
                case STREAM: {
                    xcoff = new XCOFFReader(source.getName(), source.getStream(), 0L, source.getStream().length());
                    break;
                }
                default: {
                    String msg = String.format("The library %s could not be read from a source type of %s", source.getName(), source.getType().name());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        catch (IllegalArgumentException e) {
            ARReader reader = null;
            switch (source.getType()) {
                case FILE: {
                    reader = new ARReader(source.getFile());
                    break;
                }
                case STREAM: {
                    reader = new ARReader(source.getStream());
                    break;
                }
                default: {
                    String msg = String.format("The library %s could not be read from a source type of %s", source.getName(), source.getType().name());
                    throw new IllegalArgumentException(msg);
                }
            }
            long offset = reader.offsetOfModule(objectName);
            long size = reader.offsetOfModule(objectName);
            if (offset < 0L || size < 0L) {
                throw new IOException("Can't find object " + objectName + " in module " + source.getName() + ". offset = " + offset + ", size = " + size);
            }
            switch (source.getType()) {
                case FILE: {
                    xcoff = new XCOFFReader(source.getFile(), offset, size);
                    break;
                }
                case STREAM: {
                    xcoff = new XCOFFReader(source.getName(), source.getStream(), offset, size);
                    break;
                }
                default: {
                    String msg = String.format("The library %s could not be read from a source type of %s", source.getName(), source.getType().name());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        this.openFileTracker.add(xcoff);
        return xcoff;
    }

    List<? extends IOSThread> getThreads() {
        LinkedList<IOSThread> threads = new LinkedList<IOSThread>();
        long sizeofThread = this.threadSize(216L);
        try {
            threads.add(this.readThread(216L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this._threadCount; ++i) {
            try {
                threads.add(this.readThread(this._threadOffset + (long)i * sizeofThread));
                continue;
            }
            catch (IOException ex) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.aix.AIXDumpReader", "getThreads", "Error adding thread", ex);
            }
        }
        return threads;
    }

    private IOSThread readThread(long offset) throws IOException {
        this.seek(offset);
        long tid = this.readAddress();
        this.readInt();
        int ti_policy = this.readInt();
        int ti_pri = this.readInt();
        int ti_state = this.readInt();
        int ti_flag = this.readInt();
        int ti_scount = this.readInt();
        int ti_wtype = this.readInt();
        int ti_wchan = this.readInt();
        int ti_cpu = this.readInt();
        int ti_cpuid = this.readInt();
        this.readSigset();
        this.readSigset();
        this.readInt();
        this.readAddress();
        int signalNumber = 0xFF & this.readByte();
        Map<String, Number> registers = this.readRegisters(offset);
        Properties properties = new Properties();
        properties.put("scheduling policy", Integer.toHexString(ti_policy));
        properties.put("current effective priority", Integer.toHexString(ti_pri));
        properties.put("thread state", Integer.toHexString(ti_state));
        properties.put("thread flags", Integer.toHexString(ti_flag));
        properties.put("suspend count", Integer.toHexString(ti_scount));
        properties.put("type of thread wait", Integer.toHexString(ti_wtype));
        properties.put("wait channel", Integer.toHexString(ti_wchan));
        properties.put("processor usage", Integer.toHexString(ti_cpu));
        properties.put("processor on which I'm bound", Integer.toHexString(ti_cpuid));
        properties.put("current/last signal taken", Integer.toHexString(signalNumber));
        long stackPointer = this.getStackPointerFrom(registers);
        IMemoryRange range = this.getProcess().getMemoryRangeForAddress(stackPointer);
        if (null == range) {
            throw new IOException("Cannot find memory range for stackPointer " + Long.toHexString(stackPointer));
        }
        MemoryRange stackRange = new MemoryRange(this.getProcess().getAddressSpace(), range, "stack");
        return new AIXOSThread(this.getProcess(), tid, Collections.singletonList(stackRange), properties, registers);
    }

    private void readSigset() throws IOException {
        this.readBytes(this.is64Bit() ? 32 : 8);
    }

    @Override
    public String getDumpFormat() {
        return "xcoff";
    }

    protected AIXProcessAddressSpace getProcess() {
        return this._process;
    }

    public List<IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public Platform getPlatform() {
        return Platform.AIX;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    long getEnvironmentHandle() throws CorruptDataException {
        try {
            this.loadUserInfo();
        }
        catch (IOException e) {
            throw new CorruptDataException(e);
        }
        return this._environmentHandle;
    }

    List<IModule> getModules() {
        return this._modules;
    }

    IModule getExecutable() {
        return this._executable;
    }

    long getProcessId() {
        return this._pid;
    }

    public static boolean isAIXDump(byte[] data, long filesize) {
        int version = AIXDumpReader.readInt(data, 4);
        if (version != 267312561 && version != 267312562) {
            return false;
        }
        long fdsinfox = AIXDumpReader.readLong(data, 8);
        long loader = AIXDumpReader.readLong(data, 16);
        return fdsinfox > 0L && loader > 0L && loader > fdsinfox && fdsinfox < filesize && loader < filesize;
    }

    public static ICore getReaderForFile(File file) throws IOException, InvalidDumpFormatException {
        ClosingFileReader reader = new ClosingFileReader(file, ByteOrder.BIG_ENDIAN);
        byte[] buffer = new byte[128];
        reader.readFully(buffer);
        if (!AIXDumpReader.isAIXDump(buffer, file.length())) {
            reader.close();
            throw new InvalidDumpFormatException("File " + file.getAbsolutePath() + " is not an AIX dump");
        }
        reader.seek(4L);
        int version = reader.readInt();
        boolean is64Bit = false;
        if (version == 267312561) {
            reader.seek(1056L);
            int flags = reader.readInt();
            is64Bit = (1 & flags) != 0;
        } else if (version == 267312562) {
            is64Bit = true;
        } else {
            throw new InvalidDumpFormatException("Unrecognised core file version: " + Long.toHexString(version));
        }
        if (is64Bit) {
            return new AIX64DumpReader(file, reader);
        }
        return new AIX32DumpReader(file, reader);
    }

    public static ICore getReaderForFile(ImageInputStream in) throws IOException, InvalidDumpFormatException {
        byte[] buffer = new byte[128];
        in.seek(0L);
        in.read(buffer);
        if (!AIXDumpReader.isAIXDump(buffer, Long.MAX_VALUE)) {
            throw new InvalidDumpFormatException("The supplied input stream is not an AIX dump");
        }
        in.seek(4L);
        int version = in.readInt();
        boolean is64Bit = false;
        if (version == 267312561) {
            in.seek(1056L);
            int flags = in.readInt();
            is64Bit = (1 & flags) != 0;
        } else if (version == 267312562) {
            is64Bit = true;
        } else {
            throw new InvalidDumpFormatException("Unrecognised core file version: " + Long.toHexString(version));
        }
        if (is64Bit) {
            return new AIX64DumpReader(in);
        }
        return new AIX32DumpReader(in);
    }

    @Override
    public void close() throws IOException {
        for (XCOFFReader reader : this.openFileTracker) {
            reader.close();
        }
        this.resolver.dispose();
        super.close();
    }

    class AIXOSThread
    extends BaseAIXOSThread {
        private final long tid;
        private final List<? extends IMemoryRange> memoryRanges;
        private final Properties properties;
        private final Map<String, Number> registers;

        protected AIXOSThread(IProcess process, long tid, List<? extends IMemoryRange> memoryRanges, Properties properties, Map<String, Number> registers) {
            super(process);
            this.tid = tid;
            this.memoryRanges = memoryRanges;
            this.properties = properties;
            this.registers = registers;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return Collections.unmodifiableList(this.memoryRanges);
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        public List<? extends IRegister> getRegisters() {
            ArrayList<Register> toReturn = new ArrayList<Register>(this.registers.size());
            for (String name : this.registers.keySet()) {
                Number value = this.registers.get(name);
                toReturn.add(new Register(name, value));
            }
            return toReturn;
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.tid;
        }

        @Override
        public long getInstructionPointer() {
            return AIXDumpReader.this.getInstructionPointerFrom(this.registers);
        }

        @Override
        public long getBasePointer() {
            return AIXDumpReader.this.getLinkRegisterFrom(this.registers);
        }

        @Override
        public long getStackPointer() {
            return AIXDumpReader.this.getStackPointerFrom(this.registers);
        }
    }
}

