/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.HelperBase;
import com.ibm.j9ddr.PrimitiveAccessor;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;

final class PointerHelper
extends HelperBase {
    private static final Pattern ConstPattern = Pattern.compile("\\s*\\bconst\\s+");
    private static final Set<String> predefinedDataTypes;
    private static final Set<String> predefinedPointerTypes;
    private static final Pattern TypeTagPattern;
    private final Type abstractPointerType;
    private final String[] accessorThrows;
    private final String basePrefix;
    private final String className;
    private final Type classType;
    private final ClassWriter clazz;
    private final StructureReader reader;
    private final Type scalarType;
    private final StructureReader.StructureDescriptor structure;
    private final StructureTypeManager typeManager;
    private final Type udataType;

    private static Set<String> addNames(Set<String> set, String names) {
        set.addAll(Arrays.asList(names.split(" ")));
        return set;
    }

    private static void doAccessorAnnotation(MethodVisitor method, StructureReader.FieldDescriptor field) {
        Type annotationType = Type.getObjectType("com/ibm/j9ddr/GeneratedFieldAccessor");
        AnnotationVisitor annotation = method.visitAnnotation(annotationType.getDescriptor(), true);
        annotation.visit("offsetFieldName", String.format("_%sOffset_", field.getName()));
        annotation.visit("declaredType", field.getDeclaredType());
        annotation.visitEnd();
    }

    private static String generalizeSimpleType(String type2) {
        if ("I32".equals(type2) || "I64".equals(type2)) {
            return "IDATA";
        }
        if ("U32".equals(type2) || "U64".equals(type2)) {
            return "UDATA";
        }
        return type2;
    }

    static byte[] getClassBytes(StructureReader reader, StructureTypeManager typeManager, StructureReader.StructureDescriptor structure, String className) {
        PointerHelper helper = new PointerHelper(reader, typeManager, structure, className);
        return helper.generate();
    }

    private static String getEnumType(String enumType) {
        int start = enumType.startsWith("enum ") ? 5 : 0;
        int end = enumType.length();
        if (enumType.endsWith("[]")) {
            end -= 2;
        }
        return enumType.substring(start, end);
    }

    private static String getTargetType(String pointerType) {
        int firstStar;
        String type2 = ConstPattern.matcher(pointerType).replaceAll("").trim();
        if (type2.indexOf(42, (firstStar = type2.indexOf(42)) + 1) > 0) {
            return "Pointer";
        }
        if ((type2 = type2.substring(0, firstStar).trim()).equals("bool")) {
            return "Bool";
        }
        if (type2.equals("double")) {
            return "Double";
        }
        if (type2.equals("float")) {
            return "Float";
        }
        if (type2.equals("void")) {
            return "Void";
        }
        return type2;
    }

    private static String removeTypeTags(String type2) {
        return TypeTagPattern.matcher(type2).replaceAll("").trim();
    }

    private PointerHelper(StructureReader reader, StructureTypeManager typeManager, StructureReader.StructureDescriptor structure, String className) {
        int index = className.indexOf("/pointer/generated/");
        if (index <= 0) {
            throw new IllegalArgumentException(className);
        }
        String prefix = className.substring(0, index + 1);
        this.abstractPointerType = Type.getObjectType(prefix + "pointer/AbstractPointer");
        this.accessorThrows = new String[]{"com/ibm/j9ddr/CorruptDataException"};
        this.basePrefix = prefix;
        this.className = className;
        this.classType = Type.getObjectType(className);
        this.clazz = new ClassWriter(0);
        this.scalarType = Type.getObjectType(prefix + "types/Scalar");
        this.reader = reader;
        this.structure = structure;
        this.typeManager = typeManager;
        this.udataType = Type.getObjectType(prefix + "types/UDATA");
    }

    private void doAccessorMethods() {
        block23: for (StructureReader.FieldDescriptor field : this.structure.getFields()) {
            String fieldName = field.getName();
            if (fieldName.isEmpty() || fieldName.indexOf(35) >= 0) continue;
            String typeName = field.getType();
            int type2 = this.typeManager.getType(typeName);
            switch (type2) {
                case 120: {
                    this.doStructureMethod(field);
                    continue block23;
                }
                case 121: {
                    this.doStructurePointerMethod(field);
                    continue block23;
                }
                case 110: {
                    this.doPointerMethod(field);
                    continue block23;
                }
                case 113: {
                    this.doArrayMethod(field);
                    continue block23;
                }
                case 111: {
                    this.doSRPMethod(field, false);
                    continue block23;
                }
                case 112: {
                    this.doSRPMethod(field, true);
                    continue block23;
                }
                case 114: {
                    this.doSRPPointerMethod(field, false);
                    continue block23;
                }
                case 115: {
                    this.doSRPPointerMethod(field, true);
                    continue block23;
                }
                case 130: {
                    this.doFJ9ObjectMethod(field);
                    continue block23;
                }
                case 131: {
                    this.doFJ9ObjectPointerMethod(field);
                    continue block23;
                }
                case 132: {
                    this.doJ9ObjectClassMethod(field);
                    continue block23;
                }
                case 133: {
                    this.doJ9ObjectClassPointerMethod(field);
                    continue block23;
                }
                case 134: {
                    this.doJ9ObjectMonitorMethod(field);
                    continue block23;
                }
                case 135: {
                    this.doJ9ObjectMonitorPointerMethod(field);
                    continue block23;
                }
                case 0: {
                    this.doStructureMethod(field);
                    continue block23;
                }
                case 100: {
                    this.doBooleanMethod(field);
                    continue block23;
                }
                case 102: {
                    this.doDoubleMethod(field);
                    continue block23;
                }
                case 103: {
                    this.doFloatMethod(field);
                    continue block23;
                }
                case 101: {
                    this.doEnumMethod(field);
                    continue block23;
                }
                case 105: {
                    this.doEnumPointerMethod(field);
                    continue block23;
                }
                case 104: {
                    int colonIndex = typeName.indexOf(58);
                    if (colonIndex <= 0) {
                        throw new IllegalArgumentException(String.format("%s.%s : %s is not a valid bitfield", this.structure.getName(), fieldName, typeName));
                    }
                    String baseType = typeName.substring(0, colonIndex);
                    int width = Integer.parseInt(typeName.substring(colonIndex + 1));
                    this.doBitfieldMethod(field, baseType, width);
                    continue block23;
                }
            }
            if (1 > type2 || type2 > 99) continue;
            this.doSimpleTypeMethod(field, type2);
        }
    }

    private void doArrayMethod(StructureReader.FieldDescriptor field) {
        String fieldType = field.getType();
        String componentType = fieldType.substring(0, fieldType.lastIndexOf(91)).trim();
        int type2 = this.typeManager.getType(componentType);
        switch (type2) {
            case 100: {
                this.doEAMethod("Bool", field);
                return;
            }
            case 102: {
                this.doEAMethod("Double", field);
                return;
            }
            case 101: {
                this.doEnumEAMethod(field);
                return;
            }
            case 103: {
                this.doEAMethod("Float", field);
                return;
            }
            case 130: {
                this.doEAMethod("ObjectReference", field);
                return;
            }
            case 132: {
                this.doEAMethod("ObjectClassReference", field);
                return;
            }
            case 134: {
                this.doEAMethod("ObjectMonitorReference", field);
                return;
            }
            case 120: {
                this.doEAMethod(PointerHelper.removeTypeTags(componentType), field);
                return;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                this.doEAMethod("Pointer", field);
                return;
            }
            default: {
                if (1 > type2 || type2 > 99) break;
                this.doEAMethod(componentType, field);
                return;
            }
            case 104: 
            case 111: 
            case 112: 
        }
        throw new IllegalArgumentException("Unrecognized array: " + fieldType);
    }

    private void doBitfieldMethod(StructureReader.FieldDescriptor field, String baseType, int width) {
        String fieldName = field.getName();
        Type qualifiedBaseType = Type.getObjectType(this.qualifyType(baseType));
        Type qualifiedReturnType = Type.getObjectType(this.qualifyType(PointerHelper.generalizeSimpleType(baseType)));
        String returnDesc = Type.getMethodDescriptor(qualifiedReturnType, new Type[0]);
        String startFieldName = String.format("_%s_s_", fieldName);
        String accessorName = String.format("get%sBitfield", baseType);
        String accessorDesc = Type.getMethodDescriptor(qualifiedBaseType, Type.INT_TYPE, Type.INT_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, fieldName, returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(178, this.getStructureClassName(), startFieldName, Type.INT_TYPE.getDescriptor());
        PointerHelper.loadInt(method, width);
        method.visitMethodInsn(182, this.className, accessorName, accessorDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
    }

    private void doBooleanMethod(StructureReader.FieldDescriptor field) {
        String returnDesc = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]);
        String accessorDesc = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getBoolAtOffset", accessorDesc, false);
        method.visitInsn(172);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Bool", field);
    }

    private void doClassAnnotation() {
        Type annotationType = Type.getObjectType("com/ibm/j9ddr/GeneratedPointerClass");
        AnnotationVisitor annotation = this.clazz.visitAnnotation(annotationType.getDescriptor(), true);
        Type structureType = Type.getObjectType(this.getStructureClassName());
        annotation.visit("structureClass", structureType);
        annotation.visitEnd();
    }

    private void doConstructors(String superClassName) {
        String abstractPointerFromLong = Type.getMethodDescriptor(this.abstractPointerType, Type.LONG_TYPE);
        String abstractPointerFromScalar = Type.getMethodDescriptor(this.abstractPointerType, this.scalarType);
        String classFromLong = Type.getMethodDescriptor(this.classType, Type.LONG_TYPE);
        String classFromScalar = Type.getMethodDescriptor(this.classType, this.scalarType);
        MethodVisitor method = this.clazz.visitMethod(4, "<init>", voidFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(183, superClassName, "<init>", voidFromLong, false);
        method.visitInsn(177);
        method.visitMaxs(3, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(9, "cast", classFromLong, null, null);
        Label nonNull = new Label();
        method.visitCode();
        method.visitVarInsn(22, 0);
        method.visitInsn(9);
        method.visitInsn(148);
        method.visitJumpInsn(154, nonNull);
        method.visitFieldInsn(178, this.className, "NULL", this.classType.getDescriptor());
        method.visitInsn(176);
        method.visitLabel(nonNull);
        method.visitFrame(3, 0, null, 0, null);
        method.visitTypeInsn(187, this.className);
        method.visitInsn(89);
        method.visitVarInsn(22, 0);
        method.visitMethodInsn(183, this.className, "<init>", voidFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(4, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(9, "cast", Type.getMethodDescriptor(this.classType, this.abstractPointerType), null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, this.abstractPointerType.getInternalName(), "getAddress", longFromVoid, false);
        method.visitMethodInsn(184, this.className, "cast", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(2, 1);
        method.visitEnd();
        method = this.clazz.visitMethod(9, "cast", Type.getMethodDescriptor(this.classType, this.udataType), null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, this.udataType.getInternalName(), "longValue", longFromVoid, false);
        method.visitMethodInsn(184, this.className, "cast", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(2, 1);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "add", classFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        PointerHelper.loadLong(method, this.structure.getSizeOf());
        method.visitInsn(105);
        method.visitMethodInsn(182, this.className, "addOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(5, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "add", abstractPointerFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(182, this.className, "add", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "add", classFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", longFromVoid, false);
        method.visitMethodInsn(182, this.className, "add", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "add", abstractPointerFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.className, "add", classFromScalar, false);
        method.visitInsn(176);
        method.visitMaxs(2, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "addOffset", classFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        method.visitVarInsn(22, 1);
        method.visitInsn(97);
        method.visitMethodInsn(184, this.className, "cast", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(4, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "addOffset", abstractPointerFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(182, this.className, "addOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "addOffset", classFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", longFromVoid, false);
        method.visitMethodInsn(182, this.className, "addOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "addOffset", abstractPointerFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.className, "addOffset", classFromScalar, false);
        method.visitInsn(176);
        method.visitMaxs(2, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "sub", classFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        PointerHelper.loadLong(method, this.structure.getSizeOf());
        method.visitInsn(105);
        method.visitMethodInsn(182, this.className, "subOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(5, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "sub", abstractPointerFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(182, this.className, "sub", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "sub", classFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", longFromVoid, false);
        method.visitMethodInsn(182, this.className, "sub", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "sub", abstractPointerFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.className, "sub", classFromScalar, false);
        method.visitInsn(176);
        method.visitMaxs(2, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "subOffset", classFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        method.visitVarInsn(22, 1);
        method.visitInsn(101);
        method.visitMethodInsn(184, this.className, "cast", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(5, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "subOffset", abstractPointerFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(182, this.className, "subOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "subOffset", classFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", longFromVoid, false);
        method.visitMethodInsn(182, this.className, "subOffset", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "subOffset", abstractPointerFromScalar, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, this.className, "subOffset", classFromScalar, false);
        method.visitInsn(176);
        method.visitMaxs(2, 2);
        method.visitEnd();
        method = this.clazz.visitMethod(1, "untag", classFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        method.visitVarInsn(22, 1);
        PointerHelper.loadLong(method, -1L);
        method.visitInsn(131);
        method.visitInsn(127);
        method.visitMethodInsn(184, this.className, "cast", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(6, 3);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "untag", abstractPointerFromLong, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitVarInsn(22, 1);
        method.visitMethodInsn(182, this.className, "untag", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 3);
        method.visitEnd();
        String classFromVoid = Type.getMethodDescriptor(this.classType, new Type[0]);
        method = this.clazz.visitMethod(1, "untag", classFromVoid, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, this.reader.getSizeOfUDATA() - 1);
        method.visitMethodInsn(182, this.className, "untag", classFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        method = this.clazz.visitMethod(4161, "untag", Type.getMethodDescriptor(this.abstractPointerType, new Type[0]), null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, this.className, "untag", classFromVoid, false);
        method.visitInsn(176);
        method.visitMaxs(1, 1);
        method.visitEnd();
        method = this.clazz.visitMethod(4, "sizeOfBaseType", longFromVoid, null, null);
        method.visitCode();
        PointerHelper.loadLong(method, this.structure.getSizeOf());
        method.visitInsn(173);
        method.visitMaxs(2, 1);
        method.visitEnd();
    }

    private void doDoubleMethod(StructureReader.FieldDescriptor field) {
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), doubleFromVoid, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getDoubleAtOffset", doubleFromLong, false);
        method.visitInsn(175);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Double", field);
    }

    private void doEAMethod(String actualType, StructureReader.FieldDescriptor field) {
        String accessorName = field.getName() + "EA";
        String returnType = PointerHelper.generalizeSimpleType(actualType);
        String qualifiedReturnType = this.qualifyPointerType(returnType);
        String qualifiedActualType = this.qualifyPointerType(actualType);
        String returnDesc = Type.getMethodDescriptor(Type.getObjectType(qualifiedReturnType), new Type[0]);
        String actualDesc = Type.getMethodDescriptor(Type.getObjectType(qualifiedActualType), Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, accessorName, returnDesc, null, this.accessorThrows);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "nonNullFieldEA", longFromLong, false);
        method.visitMethodInsn(184, qualifiedActualType, "cast", actualDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
    }

    private void doEnumEAMethod(StructureReader.FieldDescriptor field) {
        String accessorName = field.getName() + "EA";
        String enumPointerDesc = this.qualifyPointerType("Enum");
        Type enumPointerType = Type.getObjectType(enumPointerDesc);
        String returnDesc = Type.getMethodDescriptor(enumPointerType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(enumPointerType, Type.LONG_TYPE, Type.getType(Class.class));
        Type enumType = Type.getObjectType(this.qualifyType(PointerHelper.getEnumType(field.getType())));
        MethodVisitor method = this.clazz.visitMethod(1, accessorName, returnDesc, null, this.accessorThrows);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "nonNullFieldEA", longFromLong, false);
        method.visitLdcInsn(enumType);
        method.visitMethodInsn(184, enumPointerDesc, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
    }

    private void doEnumMethod(StructureReader.FieldDescriptor field) {
        String enumType = PointerHelper.getEnumType(field.getType());
        int enumSize = this.reader.getStructureSizeOf(enumType);
        PrimitiveAccessor accessor = PrimitiveAccessor.forSize(enumSize);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), longFromVoid, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, accessor.methodName, accessor.descriptor, false);
        if (!accessor.returnsLong) {
            method.visitInsn(133);
        }
        method.visitInsn(173);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEnumEAMethod(field);
    }

    private void doEnumPointerMethod(StructureReader.FieldDescriptor field) {
        String enumPointerDesc = this.qualifyPointerType("Enum");
        Type enumPointerType = Type.getObjectType(enumPointerDesc);
        String returnDesc = Type.getMethodDescriptor(enumPointerType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(enumPointerType, Type.LONG_TYPE, Type.getType(Class.class));
        String targetType = PointerHelper.getTargetType(PointerHelper.getEnumType(field.getType()));
        Type enumType = Type.getObjectType(this.qualifyType(targetType));
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitLdcInsn(enumType);
        method.visitMethodInsn(184, enumPointerDesc, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 2);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doFJ9ObjectMethod(StructureReader.FieldDescriptor field) {
        Type objectType = Type.getObjectType(this.qualifyPointerType("J9Object"));
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String accessorDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getObjectReferenceAtOffset", accessorDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("ObjectReference", field);
    }

    private void doFJ9ObjectPointerMethod(StructureReader.FieldDescriptor field) {
        String returnType = this.qualifyPointerType("ObjectReference");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, returnType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doFloatMethod(StructureReader.FieldDescriptor field) {
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), floatFromVoid, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getFloatAtOffset", floatFromLong, false);
        method.visitInsn(174);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Float", field);
    }

    private void doJ9ObjectClassMethod(StructureReader.FieldDescriptor field) {
        String returnType = this.qualifyPointerType("J9Class");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String accessorDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getObjectClassAtOffset", accessorDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("ObjectClassReference", field);
    }

    private void doJ9ObjectClassPointerMethod(StructureReader.FieldDescriptor field) {
        String returnType = this.qualifyPointerType("ObjectClassReference");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String accessorDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, returnType, "cast", accessorDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doJ9ObjectMonitorMethod(StructureReader.FieldDescriptor field) {
        String returnType = this.qualifyPointerType("J9ObjectMonitor");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String accessorDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getObjectMonitorAtOffset", accessorDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("ObjectMonitorReference", field);
    }

    private void doJ9ObjectMonitorPointerMethod(StructureReader.FieldDescriptor field) {
        String returnType = this.qualifyPointerType("ObjectMonitorReference");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, returnType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doNullInstance() {
        this.clazz.visitField(25, "NULL", this.classType.getDescriptor(), null, null).visitEnd();
        MethodVisitor clinit = this.clazz.visitMethod(8, "<clinit>", voidMethod, null, null);
        clinit.visitCode();
        clinit.visitTypeInsn(187, this.className);
        clinit.visitInsn(89);
        clinit.visitInsn(9);
        clinit.visitMethodInsn(183, this.className, "<init>", voidFromLong, false);
        clinit.visitFieldInsn(179, this.className, "NULL", this.classType.getDescriptor());
        clinit.visitInsn(177);
        clinit.visitMaxs(4, 0);
        clinit.visitEnd();
    }

    private void doPointerMethod(StructureReader.FieldDescriptor field) {
        String targetType = PointerHelper.getTargetType(PointerHelper.removeTypeTags(field.getType()));
        String qualifiedTargetType = this.qualifyPointerType(targetType);
        String castDesc = Type.getMethodDescriptor(Type.getObjectType(qualifiedTargetType), Type.LONG_TYPE);
        String returnType = PointerHelper.generalizeSimpleType(targetType);
        String qualifiedReturnType = this.qualifyPointerType(returnType);
        String returnDesc = Type.getMethodDescriptor(Type.getObjectType(qualifiedReturnType), new Type[0]);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, qualifiedTargetType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doSimpleTypeMethod(StructureReader.FieldDescriptor field, int type2) {
        String fieldType = field.getType();
        String returnType = PointerHelper.generalizeSimpleType(fieldType);
        String qualifiedFieldType = this.qualifyType(fieldType);
        String qualifiedReturnType = this.qualifyType(returnType);
        PrimitiveAccessor accessor = this.simpleTypeAccessor(type2);
        String returnDesc = Type.getMethodDescriptor(Type.getObjectType(qualifiedReturnType), new Type[0]);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitTypeInsn(187, qualifiedFieldType);
        method.visitInsn(89);
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, accessor.methodName, accessor.descriptor, false);
        if (!accessor.returnsLong) {
            method.visitInsn(133);
        }
        method.visitMethodInsn(183, qualifiedFieldType, "<init>", voidFromLong, false);
        method.visitInsn(176);
        method.visitMaxs(5, 1);
        method.visitEnd();
        this.doEAMethod(fieldType, field);
    }

    private void doSRPEAMethod(StructureReader.FieldDescriptor field, boolean isWide) {
        String accessorName = field.getName() + "EA";
        String returnTypeName = this.qualifyPointerType(isWide ? "WideSelfRelative" : "SelfRelative");
        Type returnType = Type.getObjectType(returnTypeName);
        String returnDesc = Type.getMethodDescriptor(returnType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(returnType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, accessorName, returnDesc, null, this.accessorThrows);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "nonNullFieldEA", longFromLong, false);
        method.visitMethodInsn(184, returnTypeName, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
    }

    private void doSRPMethod(StructureReader.FieldDescriptor field, boolean isWide) {
        String prefix = isWide ? "J9WSRP" : "J9SRP";
        int prefixLength = prefix.length();
        String rawFieldType = field.getType();
        String targetType = rawFieldType.startsWith(prefix) && rawFieldType.startsWith("(", prefixLength) ? rawFieldType.substring(prefixLength + 1, rawFieldType.length() - 1).trim() : "void";
        int type2 = this.typeManager.getType(targetType);
        switch (type2) {
            case 111: {
                targetType = "SelfRelative";
                break;
            }
            case 112: {
                targetType = "WideSelfRelative";
                break;
            }
            case 120: {
                targetType = PointerHelper.removeTypeTags(targetType);
                break;
            }
            case 0: {
                targetType = "Void";
                break;
            }
            default: {
                if (1 <= type2 && type2 <= 99) {
                    targetType = PointerHelper.removeTypeTags(targetType);
                    break;
                }
                throw new IllegalArgumentException("Unexpected SRP type: " + rawFieldType);
            }
        }
        String returnTypeName = this.qualifyPointerType(PointerHelper.generalizeSimpleType(targetType));
        Type returnType = Type.getObjectType(returnTypeName);
        String returnDesc = Type.getMethodDescriptor(returnType, new Type[0]);
        String qualifiedPointerName = this.qualifyPointerType(targetType);
        String qualifiedPointerDesc = Type.getObjectType(qualifiedPointerName).getDescriptor();
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        Label nonNull = new Label();
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        if (isWide) {
            method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
            method.visitVarInsn(55, 1);
            method.visitVarInsn(22, 1);
            method.visitInsn(9);
            method.visitInsn(148);
        } else {
            method.visitMethodInsn(182, this.className, "getIntAtOffset", intFromLong, false);
            method.visitVarInsn(54, 1);
            method.visitVarInsn(21, 1);
        }
        method.visitJumpInsn(154, nonNull);
        method.visitFieldInsn(178, qualifiedPointerName, "NULL", qualifiedPointerDesc);
        method.visitInsn(176);
        method.visitLabel(nonNull);
        method.visitFrame(1, 1, new Object[]{isWide ? LONG : INTEGER}, 0, null);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        PointerHelper.addLong(method, field.getOffset());
        if (isWide) {
            method.visitVarInsn(22, 1);
        } else {
            method.visitVarInsn(21, 1);
            method.visitInsn(133);
        }
        method.visitInsn(97);
        String castDesc = Type.getMethodDescriptor(returnType, Type.LONG_TYPE);
        method.visitMethodInsn(184, qualifiedPointerName, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(4, isWide ? 3 : 2);
        method.visitEnd();
        this.doSRPEAMethod(field, isWide);
    }

    private void doSRPPointerMethod(StructureReader.FieldDescriptor field, boolean wide) {
        String returnType = this.qualifyPointerType(wide ? "WideSelfRelative" : "SelfRelative");
        Type objectType = Type.getObjectType(returnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, returnType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doStructureMethod(StructureReader.FieldDescriptor field) {
        String fieldType = PointerHelper.removeTypeTags(field.getType());
        String returnType = "void".equals(fieldType) ? "Void" : fieldType;
        String qualifiedReturnType = this.qualifyPointerType(returnType);
        Type objectType = Type.getObjectType(qualifiedReturnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "nonNullFieldEA", longFromLong, false);
        method.visitMethodInsn(184, qualifiedReturnType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private void doStructurePointerMethod(StructureReader.FieldDescriptor field) {
        String returnType = PointerHelper.getTargetType(PointerHelper.removeTypeTags(field.getType()));
        String qualifiedReturnType = this.qualifyPointerType(returnType);
        Type objectType = Type.getObjectType(qualifiedReturnType);
        String returnDesc = Type.getMethodDescriptor(objectType, new Type[0]);
        String castDesc = Type.getMethodDescriptor(objectType, Type.LONG_TYPE);
        MethodVisitor method = this.clazz.visitMethod(1, field.getName(), returnDesc, null, this.accessorThrows);
        PointerHelper.doAccessorAnnotation(method, field);
        method.visitCode();
        method.visitVarInsn(25, 0);
        PointerHelper.loadLong(method, field.getOffset());
        method.visitMethodInsn(182, this.className, "getPointerAtOffset", longFromLong, false);
        method.visitMethodInsn(184, qualifiedReturnType, "cast", castDesc, false);
        method.visitInsn(176);
        method.visitMaxs(3, 1);
        method.visitEnd();
        this.doEAMethod("Pointer", field);
    }

    private byte[] generate() {
        String superClassName = this.structure.getSuperName();
        superClassName = superClassName.isEmpty() ? this.basePrefix + "pointer/StructurePointer" : this.basePrefix + "pointer/generated/" + superClassName + "Pointer";
        this.clazz.visit(52, 33, this.className, null, superClassName, null);
        this.doClassAnnotation();
        this.doNullInstance();
        this.doConstructors(superClassName);
        this.doAccessorMethods();
        this.clazz.visitEnd();
        return this.clazz.toByteArray();
    }

    private String getStructureClassName() {
        return this.basePrefix + "structure/" + this.structure.getName();
    }

    private String qualifyPointerType(String type2) {
        String subPackage = predefinedPointerTypes.contains(type2) ? "pointer/" : "pointer/generated/";
        return this.basePrefix + subPackage + type2 + "Pointer";
    }

    private String qualifyType(String type2) {
        String subPackage = predefinedDataTypes.contains(type2) ? "types/" : "structure/";
        return this.basePrefix + subPackage + type2;
    }

    private PrimitiveAccessor simpleTypeAccessor(int type2) {
        int size;
        switch (type2) {
            case 1: 
            case 6: {
                size = 1;
                break;
            }
            case 2: 
            case 7: {
                size = 2;
                break;
            }
            case 3: 
            case 8: {
                size = 4;
                break;
            }
            case 4: 
            case 9: {
                size = 8;
                break;
            }
            case 5: 
            case 10: {
                size = this.reader.getSizeOfUDATA();
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + type2);
            }
        }
        return PrimitiveAccessor.forSize(size);
    }

    static {
        TypeTagPattern = Pattern.compile("\\s*\\b(class|enum|struct)\\s+");
        Set<String> common = PointerHelper.addNames(new HashSet<String>(), "I8 U8 I16 U16 I32 U32 I64 U64 IDATA UDATA Void");
        predefinedDataTypes = new HashSet<String>(common);
        PointerHelper.addNames(predefinedDataTypes, "Scalar IScalar UScalar");
        predefinedPointerTypes = new HashSet<String>(common);
        PointerHelper.addNames(predefinedPointerTypes, "Abstract Bool Double Enum Float ObjectClassReference ObjectMonitorReference");
        PointerHelper.addNames(predefinedPointerTypes, "ObjectReference Pointer SelfRelative Structure WideSelfRelative");
    }
}

