/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.ibm.jvm.MemorySafetyService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.MetaIndex;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.misc.VM;
import sun.net.www.ParseUtil;

public class Launcher {
    private static URLStreamHandlerFactory factory = new Factory();
    private static Launcher launcher = new Launcher();
    private static String bootClassPath = System.getProperty("sun.boot.class.path");
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    public Launcher() {
        ExtClassLoader extClassLoader;
        try {
            extClassLoader = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create extension class loader", iOException);
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extClassLoader);
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create application class loader", iOException);
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        com.ibm.jvm.ClassLoader.setApplicationClassLoader(this.loader);
        String string = System.getProperty("java.security.manager");
        if (string != null) {
            SecurityManager securityManager = null;
            if ("".equals(string) || "default".equals(string)) {
                securityManager = new SecurityManager();
            } else {
                try {
                    securityManager = (SecurityManager)this.loader.loadClass(string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            } else {
                throw new InternalError("Could not create SecurityManager: " + string);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static URLClassPath getBootstrapClassPath() {
        return BootClassPathHolder.bcp;
    }

    private static URL[] pathToURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            uRLArray[i] = Launcher.getFileURL(fileArray[i]);
        }
        return uRLArray;
    }

    private static File[] getClassPath(String string) {
        File[] fileArray;
        if (string != null) {
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                ++n2;
                n4 = n3 + 1;
            }
            fileArray = new File[n2];
            n3 = 0;
            n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                fileArray[n++] = n3 - n4 > 0 ? new File(string.substring(n4, n3)) : new File(".");
                n4 = n3 + 1;
            }
            fileArray[n++] = n4 < string.length() ? new File(string.substring(n4)) : new File(".");
            if (n != n2) {
                File[] fileArray2 = new File[n];
                System.arraycopy(fileArray, 0, fileArray2, 0, n);
                fileArray = fileArray2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError(malformedURLException);
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String string) {
            String string2 = PREFIX + "." + string + ".Handler";
            try {
                Class<?> clazz = Class.forName(string2);
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError("could not load " + string + "system protocol handler", reflectiveOperationException);
            }
        }
    }

    private static class BootClassPathHolder {
        static final URLClassPath bcp;

        private BootClassPathHolder() {
        }

        static {
            URL[] uRLArray = bootClassPath != null ? AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

                @Override
                public URL[] run() {
                    File[] fileArray = Launcher.getClassPath(bootClassPath);
                    int n = fileArray.length;
                    HashSet<File> hashSet = new HashSet<File>();
                    for (int i = 0; i < n; ++i) {
                        File file = fileArray[i];
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        if (file == null || !hashSet.add(file)) continue;
                        MetaIndex.registerDirectory(file);
                    }
                    return Launcher.pathToURLs(fileArray);
                }
            }) : new URL[]{};
            bcp = new URLClassPath(uRLArray, factory, null);
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(final ClassLoader classLoader) throws IOException {
            final String string = System.getProperty("java.class.path");
            final File[] fileArray = string == null ? new File[]{} : Launcher.getClassPath(string);
            return AccessController.doPrivileged(new PrivilegedAction<AppClassLoader>(){

                @Override
                public AppClassLoader run() {
                    URL[] uRLArray = string == null ? new URL[]{} : Launcher.pathToURLs(fileArray);
                    return new AppClassLoader(uRLArray, classLoader);
                }
            });
        }

        AppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader, factory);
        }

        @Override
        public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            SecurityManager securityManager;
            int n = string.lastIndexOf(46);
            if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            return super.loadClass(string, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            RuntimePermission runtimePermission = null;
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                runtimePermission = new RuntimePermission("exitVM");
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
            permissionCollection.add(runtimePermission);
            return permissionCollection;
        }

        private void appendToClassPathForInstrumentation(String string) {
            assert (Thread.holdsLock(this));
            super.addURL(Launcher.getFileURL(new File(string)));
        }

        private static AccessControlContext getContext(File[] fileArray) throws MalformedURLException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), (Certificate[])null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private static volatile ExtClassLoader instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ExtClassLoader getExtClassLoader() throws IOException {
            if (instance != null) return instance;
            Class<ExtClassLoader> clazz = ExtClassLoader.class;
            synchronized (ExtClassLoader.class) {
                if (instance != null) return instance;
                instance = ExtClassLoader.createExtClassLoader();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static ExtClassLoader createExtClassLoader() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ExtClassLoader>(){

                    @Override
                    public ExtClassLoader run() throws IOException {
                        File[] fileArray = ExtClassLoader.getExtDirs();
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            MetaIndex.registerDirectory(fileArray[i]);
                        }
                        return new ExtClassLoader(fileArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }

        void addExtURL(URL uRL) {
            super.addURL(uRL);
        }

        public ExtClassLoader(File[] fileArray) throws IOException {
            super(ExtClassLoader.getExtURLs(fileArray), null, factory);
        }

        private static File[] getExtDirs() {
            File[] fileArray;
            String string = System.getProperty("java.ext.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                int n = stringTokenizer.countTokens();
                fileArray = new File[n];
                for (int i = 0; i < n; ++i) {
                    fileArray[i] = new File(stringTokenizer.nextToken());
                }
            } else {
                fileArray = new File[]{};
            }
            return fileArray;
        }

        private static URL[] getExtURLs(File[] fileArray) throws IOException {
            Vector<URL> vector = new Vector<URL>();
            for (int i = 0; i < fileArray.length; ++i) {
                String[] stringArray = fileArray[i].list();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j].equals("meta-index")) continue;
                    File file = new File(fileArray[i], stringArray[j]);
                    vector.add(Launcher.getFileURL(file));
                }
            }
            Object[] objectArray = new URL[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        @Override
        public String findLibrary(String string) {
            string = System.mapLibraryName(string);
            URL[] uRLArray = super.getURLs();
            File file = null;
            for (int i = 0; i < uRLArray.length; ++i) {
                URI uRI;
                try {
                    uRI = uRLArray[i].toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    continue;
                }
                File file2 = Paths.get(uRI).toFile().getParentFile();
                if (file2 != null && !file2.equals(file)) {
                    File file3;
                    String string2 = VM.getSavedProperty("os.arch");
                    if (string2 != null && (file3 = new File(new File(file2, string2), string)).exists()) {
                        return file3.getAbsolutePath();
                    }
                    file3 = new File(file2, string);
                    if (file3.exists()) {
                        return file3.getAbsolutePath();
                    }
                }
                file = file2;
            }
            return null;
        }

        private static AccessControlContext getContext(File[] fileArray) throws IOException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), (Certificate[])null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }

        static {
            ClassLoader.registerAsParallelCapable();
            instance = null;
        }
    }
}

