/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;

public abstract class RenderingEngine {
    private static RenderingEngine reImpl;

    public static synchronized RenderingEngine getInstance() {
        if (reImpl != null) {
            return reImpl;
        }
        reImpl = AccessController.doPrivileged(new PrivilegedAction<RenderingEngine>(){

            @Override
            public RenderingEngine run() {
                Object object;
                String string = System.getProperty("sun.java2d.renderer", "sun.dc.DuctusRenderingEngine");
                if (string.equals("sun.dc.DuctusRenderingEngine")) {
                    try {
                        Class<?> clazz = Class.forName("sun.dc.DuctusRenderingEngine");
                        return (RenderingEngine)clazz.newInstance();
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                if (string.equals("sun.java2d.jules.JulesRenderingEngine")) {
                    try {
                        Class<?> clazz = Class.forName("sun.java2d.jules.JulesRenderingEngine");
                        return (RenderingEngine)clazz.newInstance();
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                if (string.equals("sun.java2d.pisces.PiscesRenderingEngine")) {
                    try {
                        object = Class.forName("sun.java2d.pisces.PiscesRenderingEngine");
                        return (RenderingEngine)((Class)object).newInstance();
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                object = ServiceLoader.loadInstalled(RenderingEngine.class);
                RenderingEngine renderingEngine = null;
                Iterator iterator = ((ServiceLoader)object).iterator();
                while (iterator.hasNext()) {
                    RenderingEngine renderingEngine2;
                    renderingEngine = renderingEngine2 = (RenderingEngine)iterator.next();
                    if (!renderingEngine2.getClass().getName().equals(string)) continue;
                    break;
                }
                return renderingEngine;
            }
        });
        if (reImpl == null) {
            throw new InternalError("No RenderingEngine module found");
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.java2d.renderer.trace");
        String string = AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            reImpl = new Tracer(reImpl);
        }
        return reImpl;
    }

    public abstract Shape createStrokedShape(Shape var1, float var2, int var3, int var4, float var5, float[] var6, float var7);

    public abstract void strokeTo(Shape var1, AffineTransform var2, BasicStroke var3, boolean var4, boolean var5, boolean var6, PathConsumer2D var7);

    public abstract AATileGenerator getAATileGenerator(Shape var1, AffineTransform var2, Region var3, BasicStroke var4, boolean var5, boolean var6, int[] var7);

    public abstract AATileGenerator getAATileGenerator(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, Region var17, int[] var18);

    public abstract float getMinimumAAPenSize();

    public static void feedConsumer(PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    pathConsumer2D.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pathConsumer2D.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    pathConsumer2D.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pathConsumer2D.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pathConsumer2D.closePath();
                }
            }
            pathIterator.next();
        }
    }

    static class Tracer
    extends RenderingEngine {
        RenderingEngine target;
        String name;

        public Tracer(RenderingEngine renderingEngine) {
            this.target = renderingEngine;
            this.name = renderingEngine.getClass().getName();
        }

        @Override
        public Shape createStrokedShape(Shape shape, float f, int n, int n2, float f2, float[] fArray, float f3) {
            System.out.println(this.name + ".createStrokedShape(" + shape.getClass().getName() + ", width = " + f + ", caps = " + n + ", join = " + n2 + ", miter = " + f2 + ", dashes = " + fArray + ", dashphase = " + f3 + ")");
            return this.target.createStrokedShape(shape, f, n, n2, f2, fArray, f3);
        }

        @Override
        public void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, PathConsumer2D pathConsumer2D) {
            System.out.println(this.name + ".strokeTo(" + shape.getClass().getName() + ", " + affineTransform + ", " + basicStroke + ", " + (bl ? "thin" : "wide") + ", " + (bl2 ? "normalized" : "pure") + ", " + (bl3 ? "AA" : "non-AA") + ", " + pathConsumer2D.getClass().getName() + ")");
            this.target.strokeTo(shape, affineTransform, basicStroke, bl, bl2, bl3, pathConsumer2D);
        }

        @Override
        public float getMinimumAAPenSize() {
            System.out.println(this.name + ".getMinimumAAPenSize()");
            return this.target.getMinimumAAPenSize();
        }

        @Override
        public AATileGenerator getAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
            System.out.println(this.name + ".getAATileGenerator(" + shape.getClass().getName() + ", " + affineTransform + ", " + region + ", " + basicStroke + ", " + (bl ? "thin" : "wide") + ", " + (bl2 ? "normalized" : "pure") + ")");
            return this.target.getAATileGenerator(shape, affineTransform, region, basicStroke, bl, bl2, nArray);
        }

        @Override
        public AATileGenerator getAATileGenerator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Region region, int[] nArray) {
            System.out.println(this.name + ".getAATileGenerator(" + d + ", " + d2 + ", " + d3 + ", " + d4 + ", " + d5 + ", " + d6 + ", " + d7 + ", " + d8 + ", " + region + ")");
            return this.target.getAATileGenerator(d, d2, d3, d4, d5, d6, d7, d8, region, nArray);
        }
    }
}

