/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;
import java.util.function.LongBinaryOperator;

public class LongAccumulator
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private final LongBinaryOperator function;
    private final long identity;

    public LongAccumulator(LongBinaryOperator longBinaryOperator, long l) {
        this.function = longBinaryOperator;
        this.base = this.identity = l;
    }

    public void accumulate(long l) {
        long l2;
        long l3;
        Striped64.Cell[] cellArray = this.cells;
        if (this.cells != null || (l3 = this.function.applyAsLong(l2 = this.base, l)) != l2 && !this.casBase(l2, l3)) {
            long l4;
            Striped64.Cell cell;
            int n;
            boolean bl = true;
            if (cellArray == null || (n = cellArray.length - 1) < 0 || (cell = cellArray[LongAccumulator.getProbe() & n]) == null || !(bl = (l3 = this.function.applyAsLong(l4 = cell.value, l)) == l4 || cell.cas(l4, l3))) {
                this.longAccumulate(l, this.function, bl);
            }
        }
    }

    public long get() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                l = this.function.applyAsLong(l, cell.value);
            }
        }
        return l;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = this.identity;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                cell.value = this.identity;
            }
        }
    }

    public long getThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        this.base = this.identity;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                long l2 = cell.value;
                cell.value = this.identity;
                l = this.function.applyAsLong(l, l2);
            }
        }
        return l;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final long value;
        private final LongBinaryOperator function;
        private final long identity;

        SerializationProxy(LongAccumulator longAccumulator) {
            this.function = longAccumulator.function;
            this.identity = longAccumulator.identity;
            this.value = longAccumulator.get();
        }

        private Object readResolve() {
            LongAccumulator longAccumulator = new LongAccumulator(this.function, this.identity);
            longAccumulator.base = this.value;
            return longAccumulator;
        }
    }
}

