/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.RSAKeyFactory;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Destroyable {
    private static final long serialVersionUID = 8560764496984239182L;
    private static final BigInteger THREE;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private transient RSAKey rsaKey = null;
    private transient boolean destroyed = false;
    private static final String[] z;

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        RSAKeyFactory.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        this.a();
        try {
            byte[] byArray = RSAPublicKey.a(bigInteger, bigInteger2);
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[7] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPublicKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[6]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        RSAKeyFactory.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        this.a();
        try {
            this.rsaKey = RSAKey.createPublicKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    private void a() throws InvalidKeyException {
        if (this.publicExponent.compareTo(this.modulus) >= 0) {
            throw new InvalidKeyException(z[3]);
        }
        if (this.publicExponent.compareTo(THREE) < 0) {
            throw new InvalidKeyException(z[4]);
        }
    }

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgIdRSA();
            byte[] byArray = rSAKey.getPublicKeyBytes();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.rsaKey = rSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[5]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public BigInteger getModulus() {
        this.c();
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.c();
        return this.publicExponent;
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    RSAKey b() {
        return this.rsaKey;
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getPositiveBigInteger();
            this.publicExponent = derValueArray[1].getPositiveBigInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1], iOException);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0005?98|'~$;9 ,55m&~\u0002\u0007Xc.%6u*=p?|:";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                block18: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block18;
                    n5 = n5;
                    if (n5 <= n4) break block19;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 67;
                            break;
                        }
                        case 1: {
                            n6 = 94;
                            break;
                        }
                        case 2: {
                            n6 = 80;
                            break;
                        }
                        case 3: {
                            n6 = 84;
                            break;
                        }
                        default: {
                            n6 = 25;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\n0&5u*:p\u0006J\u0002~ !{/73tr&'";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001769'9(;)tp0~>;9/1>3|1~&5u*:";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "&& ;w&0$tp0~<5k$;\"tm+?>tt,:%8l0";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "&& ;w&0$tp0~#9x/25&9761:9p";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0005?98|'~$;9 ,55m&~\u0002\u0007Xc.%6u*=p?|:";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0005?98|'~$;9 ,55m&~\u0002\u0007Xc.%6u*=p?|:";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u00001%8}c0? 9\u0007\u001b\u0002t|-=?0|y~";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        THREE = BigInteger.valueOf(3L);
    }
}

